/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.rank_eval;

import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalMetricDiscountedCumulativeGain;
import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalMetricExpectedReciprocalRank;
import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalMetricMeanReciprocalRank;
import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalMetricPrecision;
import co.elastic.clients.elasticsearch.core.rank_eval.RankEvalMetricRecall;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RankEvalMetric
implements JsonpSerializable {
    @Nullable
    private final RankEvalMetricPrecision precision;
    @Nullable
    private final RankEvalMetricRecall recall;
    @Nullable
    private final RankEvalMetricMeanReciprocalRank meanReciprocalRank;
    @Nullable
    private final RankEvalMetricDiscountedCumulativeGain dcg;
    @Nullable
    private final RankEvalMetricExpectedReciprocalRank expectedReciprocalRank;
    public static final JsonpDeserializer<RankEvalMetric> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalMetric::setupRankEvalMetricDeserializer);

    private RankEvalMetric(Builder builder) {
        this.precision = builder.precision;
        this.recall = builder.recall;
        this.meanReciprocalRank = builder.meanReciprocalRank;
        this.dcg = builder.dcg;
        this.expectedReciprocalRank = builder.expectedReciprocalRank;
    }

    public static RankEvalMetric of(Function<Builder, ObjectBuilder<RankEvalMetric>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final RankEvalMetricPrecision precision() {
        return this.precision;
    }

    @Nullable
    public final RankEvalMetricRecall recall() {
        return this.recall;
    }

    @Nullable
    public final RankEvalMetricMeanReciprocalRank meanReciprocalRank() {
        return this.meanReciprocalRank;
    }

    @Nullable
    public final RankEvalMetricDiscountedCumulativeGain dcg() {
        return this.dcg;
    }

    @Nullable
    public final RankEvalMetricExpectedReciprocalRank expectedReciprocalRank() {
        return this.expectedReciprocalRank;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.precision != null) {
            generator.writeKey("precision");
            this.precision.serialize(generator, mapper);
        }
        if (this.recall != null) {
            generator.writeKey("recall");
            this.recall.serialize(generator, mapper);
        }
        if (this.meanReciprocalRank != null) {
            generator.writeKey("mean_reciprocal_rank");
            this.meanReciprocalRank.serialize(generator, mapper);
        }
        if (this.dcg != null) {
            generator.writeKey("dcg");
            this.dcg.serialize(generator, mapper);
        }
        if (this.expectedReciprocalRank != null) {
            generator.writeKey("expected_reciprocal_rank");
            this.expectedReciprocalRank.serialize(generator, mapper);
        }
    }

    protected static void setupRankEvalMetricDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::precision, RankEvalMetricPrecision._DESERIALIZER, "precision");
        op.add(Builder::recall, RankEvalMetricRecall._DESERIALIZER, "recall");
        op.add(Builder::meanReciprocalRank, RankEvalMetricMeanReciprocalRank._DESERIALIZER, "mean_reciprocal_rank");
        op.add(Builder::dcg, RankEvalMetricDiscountedCumulativeGain._DESERIALIZER, "dcg");
        op.add(Builder::expectedReciprocalRank, RankEvalMetricExpectedReciprocalRank._DESERIALIZER, "expected_reciprocal_rank");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RankEvalMetric> {
        @Nullable
        private RankEvalMetricPrecision precision;
        @Nullable
        private RankEvalMetricRecall recall;
        @Nullable
        private RankEvalMetricMeanReciprocalRank meanReciprocalRank;
        @Nullable
        private RankEvalMetricDiscountedCumulativeGain dcg;
        @Nullable
        private RankEvalMetricExpectedReciprocalRank expectedReciprocalRank;

        public final Builder precision(@Nullable RankEvalMetricPrecision value) {
            this.precision = value;
            return this;
        }

        public final Builder precision(Function<RankEvalMetricPrecision.Builder, ObjectBuilder<RankEvalMetricPrecision>> fn) {
            return this.precision(fn.apply(new RankEvalMetricPrecision.Builder()).build());
        }

        public final Builder recall(@Nullable RankEvalMetricRecall value) {
            this.recall = value;
            return this;
        }

        public final Builder recall(Function<RankEvalMetricRecall.Builder, ObjectBuilder<RankEvalMetricRecall>> fn) {
            return this.recall(fn.apply(new RankEvalMetricRecall.Builder()).build());
        }

        public final Builder meanReciprocalRank(@Nullable RankEvalMetricMeanReciprocalRank value) {
            this.meanReciprocalRank = value;
            return this;
        }

        public final Builder meanReciprocalRank(Function<RankEvalMetricMeanReciprocalRank.Builder, ObjectBuilder<RankEvalMetricMeanReciprocalRank>> fn) {
            return this.meanReciprocalRank(fn.apply(new RankEvalMetricMeanReciprocalRank.Builder()).build());
        }

        public final Builder dcg(@Nullable RankEvalMetricDiscountedCumulativeGain value) {
            this.dcg = value;
            return this;
        }

        public final Builder dcg(Function<RankEvalMetricDiscountedCumulativeGain.Builder, ObjectBuilder<RankEvalMetricDiscountedCumulativeGain>> fn) {
            return this.dcg(fn.apply(new RankEvalMetricDiscountedCumulativeGain.Builder()).build());
        }

        public final Builder expectedReciprocalRank(@Nullable RankEvalMetricExpectedReciprocalRank value) {
            this.expectedReciprocalRank = value;
            return this;
        }

        public final Builder expectedReciprocalRank(Function<RankEvalMetricExpectedReciprocalRank.Builder, ObjectBuilder<RankEvalMetricExpectedReciprocalRank>> fn) {
            return this.expectedReciprocalRank(fn.apply(new RankEvalMetricExpectedReciprocalRank.Builder()).build());
        }

        @Override
        public RankEvalMetric build() {
            this._checkSingleUse();
            return new RankEvalMetric(this);
        }
    }
}

