/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.shutdown;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.shutdown.DeleteNodeRequest;
import co.elastic.clients.elasticsearch.shutdown.DeleteNodeResponse;
import co.elastic.clients.elasticsearch.shutdown.GetNodeRequest;
import co.elastic.clients.elasticsearch.shutdown.GetNodeResponse;
import co.elastic.clients.elasticsearch.shutdown.PutNodeRequest;
import co.elastic.clients.elasticsearch.shutdown.PutNodeResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchShutdownAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchShutdownAsyncClient> {
    public ElasticsearchShutdownAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchShutdownAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchShutdownAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchShutdownAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeleteNodeResponse> deleteNode(DeleteNodeRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeleteNodeRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeleteNodeResponse> deleteNode(Function<DeleteNodeRequest.Builder, ObjectBuilder<DeleteNodeRequest>> fn) throws IOException, ElasticsearchException {
        return this.deleteNode(fn.apply(new DeleteNodeRequest.Builder()).build());
    }

    public CompletableFuture<GetNodeResponse> getNode(GetNodeRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetNodeRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetNodeResponse> getNode(Function<GetNodeRequest.Builder, ObjectBuilder<GetNodeRequest>> fn) throws IOException, ElasticsearchException {
        return this.getNode(fn.apply(new GetNodeRequest.Builder()).build());
    }

    public CompletableFuture<GetNodeResponse> getNode() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetNodeRequest.Builder().build(), GetNodeRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PutNodeResponse> putNode(PutNodeRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PutNodeRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutNodeResponse> putNode(Function<PutNodeRequest.Builder, ObjectBuilder<PutNodeRequest>> fn) throws IOException, ElasticsearchException {
        return this.putNode(fn.apply(new PutNodeRequest.Builder()).build());
    }
}

