/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Cpu;
import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Process
implements JsonpSerializable {
    private final Cpu cpu;
    private final MemoryStats mem;
    private final int openFileDescriptors;
    private final long timestamp;
    public static final JsonpDeserializer<Process> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Process::setupProcessDeserializer);

    private Process(Builder builder) {
        this.cpu = ApiTypeHelper.requireNonNull(builder.cpu, this, "cpu");
        this.mem = ApiTypeHelper.requireNonNull(builder.mem, this, "mem");
        this.openFileDescriptors = ApiTypeHelper.requireNonNull(builder.openFileDescriptors, this, "openFileDescriptors");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
    }

    public static Process of(Function<Builder, ObjectBuilder<Process>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Cpu cpu() {
        return this.cpu;
    }

    public final MemoryStats mem() {
        return this.mem;
    }

    public final int openFileDescriptors() {
        return this.openFileDescriptors;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu");
        this.cpu.serialize(generator, mapper);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("open_file_descriptors");
        generator.write(this.openFileDescriptors);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupProcessDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cpu, Cpu._DESERIALIZER, "cpu");
        op.add(Builder::mem, MemoryStats._DESERIALIZER, "mem");
        op.add(Builder::openFileDescriptors, JsonpDeserializer.integerDeserializer(), "open_file_descriptors");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Process> {
        private Cpu cpu;
        private MemoryStats mem;
        private Integer openFileDescriptors;
        private Long timestamp;

        public final Builder cpu(Cpu value) {
            this.cpu = value;
            return this;
        }

        public final Builder cpu(Function<Cpu.Builder, ObjectBuilder<Cpu>> fn) {
            return this.cpu(fn.apply(new Cpu.Builder()).build());
        }

        public final Builder mem(MemoryStats value) {
            this.mem = value;
            return this;
        }

        public final Builder mem(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.mem(fn.apply(new MemoryStats.Builder()).build());
        }

        public final Builder openFileDescriptors(int value) {
            this.openFileDescriptors = value;
            return this;
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public Process build() {
            this._checkSingleUse();
            return new Process(this);
        }
    }
}

