/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.DataPathStats;
import co.elastic.clients.elasticsearch.nodes.FileSystemTotal;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class FileSystem
implements JsonpSerializable {
    private final List<DataPathStats> data;
    private final long timestamp;
    private final FileSystemTotal total;
    public static final JsonpDeserializer<FileSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileSystem::setupFileSystemDeserializer);

    private FileSystem(Builder builder) {
        this.data = ApiTypeHelper.unmodifiableRequired(builder.data, (Object)this, "data");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.total = ApiTypeHelper.requireNonNull(builder.total, this, "total");
    }

    public static FileSystem of(Function<Builder, ObjectBuilder<FileSystem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<DataPathStats> data() {
        return this.data;
    }

    public final long timestamp() {
        return this.timestamp;
    }

    public final FileSystemTotal total() {
        return this.total;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.data)) {
            generator.writeKey("data");
            generator.writeStartArray();
            for (DataPathStats item0 : this.data) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
        generator.writeKey("total");
        this.total.serialize(generator, mapper);
    }

    protected static void setupFileSystemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::data, JsonpDeserializer.arrayDeserializer(DataPathStats._DESERIALIZER), "data");
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp");
        op.add(Builder::total, FileSystemTotal._DESERIALIZER, "total");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<FileSystem> {
        private List<DataPathStats> data;
        private Long timestamp;
        private FileSystemTotal total;

        public final Builder data(List<DataPathStats> list) {
            this.data = Builder._listAddAll(this.data, list);
            return this;
        }

        public final Builder data(DataPathStats value, DataPathStats ... values) {
            this.data = Builder._listAdd(this.data, value, values);
            return this;
        }

        public final Builder data(Function<DataPathStats.Builder, ObjectBuilder<DataPathStats>> fn) {
            return this.data(fn.apply(new DataPathStats.Builder()).build(), new DataPathStats[0]);
        }

        public final Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        public final Builder total(FileSystemTotal value) {
            this.total = value;
            return this;
        }

        public final Builder total(Function<FileSystemTotal.Builder, ObjectBuilder<FileSystemTotal>> fn) {
            return this.total(fn.apply(new FileSystemTotal.Builder()).build());
        }

        @Override
        public FileSystem build() {
            this._checkSingleUse();
            return new FileSystem(this);
        }
    }
}

