/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;

public abstract class AcknowledgedResponseBase
implements JsonpSerializable {
    private final boolean acknowledged;

    protected AcknowledgedResponseBase(AbstractBuilder<?> builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(((AbstractBuilder)builder).acknowledged, this, "acknowledged");
    }

    public final boolean acknowledged() {
        return this.acknowledged;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupAcknowledgedResponseBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends ObjectBuilderBase {
        private Boolean acknowledged;

        protected AbstractBuilder() {
        }

        public final BuilderT acknowledged(boolean value) {
            this.acknowledged = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }
}

