/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.PagerDutyContext;
import co.elastic.clients.elasticsearch.watcher.PagerDutyEventType;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class PagerDutyEvent
implements JsonpSerializable {
    private final String account;
    private final boolean attachPayload;
    private final String client;
    private final String clientUrl;
    private final List<PagerDutyContext> context;
    private final String description;
    private final PagerDutyEventType eventType;
    private final String incidentKey;
    public static final JsonpDeserializer<PagerDutyEvent> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PagerDutyEvent::setupPagerDutyEventDeserializer);

    private PagerDutyEvent(Builder builder) {
        this.account = ApiTypeHelper.requireNonNull(builder.account, this, "account");
        this.attachPayload = ApiTypeHelper.requireNonNull(builder.attachPayload, this, "attachPayload");
        this.client = ApiTypeHelper.requireNonNull(builder.client, this, "client");
        this.clientUrl = ApiTypeHelper.requireNonNull(builder.clientUrl, this, "clientUrl");
        this.context = ApiTypeHelper.unmodifiableRequired(builder.context, (Object)this, "context");
        this.description = ApiTypeHelper.requireNonNull(builder.description, this, "description");
        this.eventType = ApiTypeHelper.requireNonNull(builder.eventType, this, "eventType");
        this.incidentKey = ApiTypeHelper.requireNonNull(builder.incidentKey, this, "incidentKey");
    }

    public static PagerDutyEvent of(Function<Builder, ObjectBuilder<PagerDutyEvent>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String account() {
        return this.account;
    }

    public final boolean attachPayload() {
        return this.attachPayload;
    }

    public final String client() {
        return this.client;
    }

    public final String clientUrl() {
        return this.clientUrl;
    }

    public final List<PagerDutyContext> context() {
        return this.context;
    }

    public final String description() {
        return this.description;
    }

    public final PagerDutyEventType eventType() {
        return this.eventType;
    }

    public final String incidentKey() {
        return this.incidentKey;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("account");
        generator.write(this.account);
        generator.writeKey("attach_payload");
        generator.write(this.attachPayload);
        generator.writeKey("client");
        generator.write(this.client);
        generator.writeKey("client_url");
        generator.write(this.clientUrl);
        if (ApiTypeHelper.isDefined(this.context)) {
            generator.writeKey("context");
            generator.writeStartArray();
            for (PagerDutyContext item0 : this.context) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("description");
        generator.write(this.description);
        generator.writeKey("event_type");
        this.eventType.serialize(generator, mapper);
        generator.writeKey("incident_key");
        generator.write(this.incidentKey);
    }

    protected static void setupPagerDutyEventDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::account, JsonpDeserializer.stringDeserializer(), "account");
        op.add(Builder::attachPayload, JsonpDeserializer.booleanDeserializer(), "attach_payload");
        op.add(Builder::client, JsonpDeserializer.stringDeserializer(), "client");
        op.add(Builder::clientUrl, JsonpDeserializer.stringDeserializer(), "client_url");
        op.add(Builder::context, JsonpDeserializer.arrayDeserializer(PagerDutyContext._DESERIALIZER), "context");
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::eventType, PagerDutyEventType._DESERIALIZER, "event_type");
        op.add(Builder::incidentKey, JsonpDeserializer.stringDeserializer(), "incident_key");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PagerDutyEvent> {
        private String account;
        private Boolean attachPayload;
        private String client;
        private String clientUrl;
        private List<PagerDutyContext> context;
        private String description;
        private PagerDutyEventType eventType;
        private String incidentKey;

        public final Builder account(String value) {
            this.account = value;
            return this;
        }

        public final Builder attachPayload(boolean value) {
            this.attachPayload = value;
            return this;
        }

        public final Builder client(String value) {
            this.client = value;
            return this;
        }

        public final Builder clientUrl(String value) {
            this.clientUrl = value;
            return this;
        }

        public final Builder context(List<PagerDutyContext> list) {
            this.context = Builder._listAddAll(this.context, list);
            return this;
        }

        public final Builder context(PagerDutyContext value, PagerDutyContext ... values) {
            this.context = Builder._listAdd(this.context, value, values);
            return this;
        }

        public final Builder context(Function<PagerDutyContext.Builder, ObjectBuilder<PagerDutyContext>> fn) {
            return this.context(fn.apply(new PagerDutyContext.Builder()).build(), new PagerDutyContext[0]);
        }

        public final Builder description(String value) {
            this.description = value;
            return this;
        }

        public final Builder eventType(PagerDutyEventType value) {
            this.eventType = value;
            return this;
        }

        public final Builder incidentKey(String value) {
            this.incidentKey = value;
            return this;
        }

        @Override
        public PagerDutyEvent build() {
            this._checkSingleUse();
            return new PagerDutyEvent(this);
        }
    }
}

