/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

@JsonpDeserializable
public class HttpInputResponseResult
implements JsonpSerializable {
    private final String body;
    private final Map<String, List<String>> headers;
    private final int status;
    public static final JsonpDeserializer<HttpInputResponseResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, HttpInputResponseResult::setupHttpInputResponseResultDeserializer);

    private HttpInputResponseResult(Builder builder) {
        this.body = ApiTypeHelper.requireNonNull(builder.body, this, "body");
        this.headers = ApiTypeHelper.unmodifiableRequired(builder.headers, (Object)this, "headers");
        this.status = ApiTypeHelper.requireNonNull(builder.status, this, "status");
    }

    public static HttpInputResponseResult of(Function<Builder, ObjectBuilder<HttpInputResponseResult>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String body() {
        return this.body;
    }

    public final Map<String, List<String>> headers() {
        return this.headers;
    }

    public final int status() {
        return this.status;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("body");
        generator.write(this.body);
        if (ApiTypeHelper.isDefined(this.headers)) {
            generator.writeKey("headers");
            generator.writeStartObject();
            for (Map.Entry<String, List<String>> item0 : this.headers.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.writeStartArray();
                if (item0.getValue() != null) {
                    for (String item1 : item0.getValue()) {
                        generator.write(item1);
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
        generator.writeKey("status");
        generator.write(this.status);
    }

    protected static void setupHttpInputResponseResultDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::body, JsonpDeserializer.stringDeserializer(), "body");
        op.add(Builder::headers, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer())), "headers");
        op.add(Builder::status, JsonpDeserializer.integerDeserializer(), "status");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<HttpInputResponseResult> {
        private String body;
        private Map<String, List<String>> headers;
        private Integer status;

        public final Builder body(String value) {
            this.body = value;
            return this;
        }

        public final Builder headers(Map<String, List<String>> map) {
            this.headers = Builder._mapPutAll(this.headers, map);
            return this;
        }

        public final Builder headers(String key, List<String> value) {
            this.headers = Builder._mapPut(this.headers, key, value);
            return this;
        }

        public final Builder status(int value) {
            this.status = value;
            return this;
        }

        @Override
        public HttpInputResponseResult build() {
            this._checkSingleUse();
            return new HttpInputResponseResult(this);
        }
    }
}

