/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.core.reindex.Destination;
import co.elastic.clients.elasticsearch.core.reindex.Source;
import co.elastic.clients.elasticsearch.transform.Latest;
import co.elastic.clients.elasticsearch.transform.Pivot;
import co.elastic.clients.elasticsearch.transform.PreviewTransformResponse;
import co.elastic.clients.elasticsearch.transform.RetentionPolicy;
import co.elastic.clients.elasticsearch.transform.Settings;
import co.elastic.clients.elasticsearch.transform.Sync;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class PreviewTransformRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String description;
    @Nullable
    private final Destination dest;
    @Nullable
    private final Time frequency;
    @Nullable
    private final Latest latest;
    @Nullable
    private final Pivot pivot;
    @Nullable
    private final RetentionPolicy retentionPolicy;
    @Nullable
    private final Settings settings;
    @Nullable
    private final Source source;
    @Nullable
    private final Sync sync;
    @Nullable
    private final String transformId;
    public static final JsonpDeserializer<PreviewTransformRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PreviewTransformRequest::setupPreviewTransformRequestDeserializer);
    public static final SimpleEndpoint<PreviewTransformRequest, ?> _ENDPOINT = new SimpleEndpoint<PreviewTransformRequest, PreviewTransformResponse<Object>>("es/transform.preview_transform", request -> "POST", request -> {
        boolean _transformId = true;
        boolean propsSet = false;
        if (request.transformId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.transformId, buf);
            buf.append("/_preview");
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_transform");
            buf.append("/_preview");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PreviewTransformResponse._DESERIALIZER);

    private PreviewTransformRequest(Builder builder) {
        this.description = builder.description;
        this.dest = builder.dest;
        this.frequency = builder.frequency;
        this.latest = builder.latest;
        this.pivot = builder.pivot;
        this.retentionPolicy = builder.retentionPolicy;
        this.settings = builder.settings;
        this.source = builder.source;
        this.sync = builder.sync;
        this.transformId = builder.transformId;
    }

    public static PreviewTransformRequest of(Function<Builder, ObjectBuilder<PreviewTransformRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String description() {
        return this.description;
    }

    @Nullable
    public final Destination dest() {
        return this.dest;
    }

    @Nullable
    public final Time frequency() {
        return this.frequency;
    }

    @Nullable
    public final Latest latest() {
        return this.latest;
    }

    @Nullable
    public final Pivot pivot() {
        return this.pivot;
    }

    @Nullable
    public final RetentionPolicy retentionPolicy() {
        return this.retentionPolicy;
    }

    @Nullable
    public final Settings settings() {
        return this.settings;
    }

    @Nullable
    public final Source source() {
        return this.source;
    }

    @Nullable
    public final Sync sync() {
        return this.sync;
    }

    @Nullable
    public final String transformId() {
        return this.transformId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.dest != null) {
            generator.writeKey("dest");
            this.dest.serialize(generator, mapper);
        }
        if (this.frequency != null) {
            generator.writeKey("frequency");
            this.frequency.serialize(generator, mapper);
        }
        if (this.latest != null) {
            generator.writeKey("latest");
            this.latest.serialize(generator, mapper);
        }
        if (this.pivot != null) {
            generator.writeKey("pivot");
            this.pivot.serialize(generator, mapper);
        }
        if (this.retentionPolicy != null) {
            generator.writeKey("retention_policy");
            this.retentionPolicy.serialize(generator, mapper);
        }
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.source != null) {
            generator.writeKey("source");
            this.source.serialize(generator, mapper);
        }
        if (this.sync != null) {
            generator.writeKey("sync");
            this.sync.serialize(generator, mapper);
        }
    }

    protected static void setupPreviewTransformRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description");
        op.add(Builder::dest, Destination._DESERIALIZER, "dest");
        op.add(Builder::frequency, Time._DESERIALIZER, "frequency");
        op.add(Builder::latest, Latest._DESERIALIZER, "latest");
        op.add(Builder::pivot, Pivot._DESERIALIZER, "pivot");
        op.add(Builder::retentionPolicy, RetentionPolicy._DESERIALIZER, "retention_policy");
        op.add(Builder::settings, Settings._DESERIALIZER, "settings");
        op.add(Builder::source, Source._DESERIALIZER, "source");
        op.add(Builder::sync, Sync._DESERIALIZER, "sync");
    }

    public static <TTransform> Endpoint<PreviewTransformRequest, PreviewTransformResponse<TTransform>, ErrorResponse> createPreviewTransformEndpoint(JsonpDeserializer<TTransform> tTransformDeserializer) {
        return _ENDPOINT.withResponseDeserializer(PreviewTransformResponse.createPreviewTransformResponseDeserializer(tTransformDeserializer));
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<PreviewTransformRequest> {
        @Nullable
        private String description;
        @Nullable
        private Destination dest;
        @Nullable
        private Time frequency;
        @Nullable
        private Latest latest;
        @Nullable
        private Pivot pivot;
        @Nullable
        private RetentionPolicy retentionPolicy;
        @Nullable
        private Settings settings;
        @Nullable
        private Source source;
        @Nullable
        private Sync sync;
        @Nullable
        private String transformId;

        public final Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public final Builder dest(@Nullable Destination value) {
            this.dest = value;
            return this;
        }

        public final Builder dest(Function<Destination.Builder, ObjectBuilder<Destination>> fn) {
            return this.dest(fn.apply(new Destination.Builder()).build());
        }

        public final Builder frequency(@Nullable Time value) {
            this.frequency = value;
            return this;
        }

        public final Builder frequency(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.frequency(fn.apply(new Time.Builder()).build());
        }

        public final Builder latest(@Nullable Latest value) {
            this.latest = value;
            return this;
        }

        public final Builder latest(Function<Latest.Builder, ObjectBuilder<Latest>> fn) {
            return this.latest(fn.apply(new Latest.Builder()).build());
        }

        public final Builder pivot(@Nullable Pivot value) {
            this.pivot = value;
            return this;
        }

        public final Builder pivot(Function<Pivot.Builder, ObjectBuilder<Pivot>> fn) {
            return this.pivot(fn.apply(new Pivot.Builder()).build());
        }

        public final Builder retentionPolicy(@Nullable RetentionPolicy value) {
            this.retentionPolicy = value;
            return this;
        }

        public final Builder retentionPolicy(Function<RetentionPolicy.Builder, ObjectBuilder<RetentionPolicy>> fn) {
            return this.retentionPolicy(fn.apply(new RetentionPolicy.Builder()).build());
        }

        public final Builder settings(@Nullable Settings value) {
            this.settings = value;
            return this;
        }

        public final Builder settings(Function<Settings.Builder, ObjectBuilder<Settings>> fn) {
            return this.settings(fn.apply(new Settings.Builder()).build());
        }

        public final Builder source(@Nullable Source value) {
            this.source = value;
            return this;
        }

        public final Builder source(Function<Source.Builder, ObjectBuilder<Source>> fn) {
            return this.source(fn.apply(new Source.Builder()).build());
        }

        public final Builder sync(@Nullable Sync value) {
            this.sync = value;
            return this;
        }

        public final Builder sync(Function<Sync.Builder, ObjectBuilder<Sync>> fn) {
            return this.sync(fn.apply(new Sync.Builder()).build());
        }

        public final Builder transformId(@Nullable String value) {
            this.transformId = value;
            return this;
        }

        @Override
        public PreviewTransformRequest build() {
            this._checkSingleUse();
            return new PreviewTransformRequest(this);
        }
    }
}

