/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.create_api_key;

import co.elastic.clients.elasticsearch.security.ApplicationPrivileges;
import co.elastic.clients.elasticsearch.security.create_api_key.IndexPrivileges;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RoleDescriptor
implements JsonpSerializable {
    private final List<String> cluster;
    private final List<IndexPrivileges> index;
    private final List<ApplicationPrivileges> applications;
    public static final JsonpDeserializer<RoleDescriptor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RoleDescriptor::setupRoleDescriptorDeserializer);

    private RoleDescriptor(Builder builder) {
        this.cluster = ApiTypeHelper.unmodifiableRequired(builder.cluster, (Object)this, "cluster");
        this.index = ApiTypeHelper.unmodifiableRequired(builder.index, (Object)this, "index");
        this.applications = ApiTypeHelper.unmodifiable(builder.applications);
    }

    public static RoleDescriptor of(Function<Builder, ObjectBuilder<RoleDescriptor>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> cluster() {
        return this.cluster;
    }

    public final List<IndexPrivileges> index() {
        return this.index;
    }

    public final List<ApplicationPrivileges> applications() {
        return this.applications;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.cluster)) {
            generator.writeKey("cluster");
            generator.writeStartArray();
            for (String string : this.cluster) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.index)) {
            generator.writeKey("index");
            generator.writeStartArray();
            for (IndexPrivileges indexPrivileges : this.index) {
                indexPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.applications)) {
            generator.writeKey("applications");
            generator.writeStartArray();
            for (ApplicationPrivileges applicationPrivileges : this.applications) {
                applicationPrivileges.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupRoleDescriptorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cluster, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "cluster");
        op.add(Builder::index, JsonpDeserializer.arrayDeserializer(IndexPrivileges._DESERIALIZER), "index");
        op.add(Builder::applications, JsonpDeserializer.arrayDeserializer(ApplicationPrivileges._DESERIALIZER), "applications");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<RoleDescriptor> {
        private List<String> cluster;
        private List<IndexPrivileges> index;
        @Nullable
        private List<ApplicationPrivileges> applications;

        public final Builder cluster(List<String> list) {
            this.cluster = Builder._listAddAll(this.cluster, list);
            return this;
        }

        public final Builder cluster(String value, String ... values) {
            this.cluster = Builder._listAdd(this.cluster, value, values);
            return this;
        }

        public final Builder index(List<IndexPrivileges> list) {
            this.index = Builder._listAddAll(this.index, list);
            return this;
        }

        public final Builder index(IndexPrivileges value, IndexPrivileges ... values) {
            this.index = Builder._listAdd(this.index, value, values);
            return this;
        }

        public final Builder index(Function<IndexPrivileges.Builder, ObjectBuilder<IndexPrivileges>> fn) {
            return this.index(fn.apply(new IndexPrivileges.Builder()).build(), new IndexPrivileges[0]);
        }

        public final Builder applications(List<ApplicationPrivileges> list) {
            this.applications = Builder._listAddAll(this.applications, list);
            return this;
        }

        public final Builder applications(ApplicationPrivileges value, ApplicationPrivileges ... values) {
            this.applications = Builder._listAdd(this.applications, value, values);
            return this;
        }

        public final Builder applications(Function<ApplicationPrivileges.Builder, ObjectBuilder<ApplicationPrivileges>> fn) {
            return this.applications(fn.apply(new ApplicationPrivileges.Builder()).build(), new ApplicationPrivileges[0]);
        }

        @Override
        public RoleDescriptor build() {
            this._checkSingleUse();
            return new RoleDescriptor(this);
        }
    }
}

