/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class Scripting
implements JsonpSerializable {
    private final long cacheEvictions;
    private final long compilations;
    public static final JsonpDeserializer<Scripting> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Scripting::setupScriptingDeserializer);

    private Scripting(Builder builder) {
        this.cacheEvictions = ApiTypeHelper.requireNonNull(builder.cacheEvictions, this, "cacheEvictions");
        this.compilations = ApiTypeHelper.requireNonNull(builder.compilations, this, "compilations");
    }

    public static Scripting of(Function<Builder, ObjectBuilder<Scripting>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long cacheEvictions() {
        return this.cacheEvictions;
    }

    public final long compilations() {
        return this.compilations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cache_evictions");
        generator.write(this.cacheEvictions);
        generator.writeKey("compilations");
        generator.write(this.compilations);
    }

    protected static void setupScriptingDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::cacheEvictions, JsonpDeserializer.longDeserializer(), "cache_evictions");
        op.add(Builder::compilations, JsonpDeserializer.longDeserializer(), "compilations");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<Scripting> {
        private Long cacheEvictions;
        private Long compilations;

        public final Builder cacheEvictions(long value) {
            this.cacheEvictions = value;
            return this;
        }

        public final Builder compilations(long value) {
            this.compilations = value;
            return this;
        }

        @Override
        public Scripting build() {
            this._checkSingleUse();
            return new Scripting(this);
        }
    }
}

