/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class GarbageCollectorTotal
implements JsonpSerializable {
    private final long collectionCount;
    private final String collectionTime;
    private final long collectionTimeInMillis;
    public static final JsonpDeserializer<GarbageCollectorTotal> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GarbageCollectorTotal::setupGarbageCollectorTotalDeserializer);

    private GarbageCollectorTotal(Builder builder) {
        this.collectionCount = ApiTypeHelper.requireNonNull(builder.collectionCount, this, "collectionCount");
        this.collectionTime = ApiTypeHelper.requireNonNull(builder.collectionTime, this, "collectionTime");
        this.collectionTimeInMillis = ApiTypeHelper.requireNonNull(builder.collectionTimeInMillis, this, "collectionTimeInMillis");
    }

    public static GarbageCollectorTotal of(Function<Builder, ObjectBuilder<GarbageCollectorTotal>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long collectionCount() {
        return this.collectionCount;
    }

    public final String collectionTime() {
        return this.collectionTime;
    }

    public final long collectionTimeInMillis() {
        return this.collectionTimeInMillis;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("collection_count");
        generator.write(this.collectionCount);
        generator.writeKey("collection_time");
        generator.write(this.collectionTime);
        generator.writeKey("collection_time_in_millis");
        generator.write(this.collectionTimeInMillis);
    }

    protected static void setupGarbageCollectorTotalDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::collectionCount, JsonpDeserializer.longDeserializer(), "collection_count");
        op.add(Builder::collectionTime, JsonpDeserializer.stringDeserializer(), "collection_time");
        op.add(Builder::collectionTimeInMillis, JsonpDeserializer.longDeserializer(), "collection_time_in_millis");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GarbageCollectorTotal> {
        private Long collectionCount;
        private String collectionTime;
        private Long collectionTimeInMillis;

        public final Builder collectionCount(long value) {
            this.collectionCount = value;
            return this;
        }

        public final Builder collectionTime(String value) {
            this.collectionTime = value;
            return this;
        }

        public final Builder collectionTimeInMillis(long value) {
            this.collectionTimeInMillis = value;
            return this;
        }

        @Override
        public GarbageCollectorTotal build() {
            this._checkSingleUse();
            return new GarbageCollectorTotal(this);
        }
    }
}

