/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class ExtendedMemoryStats
extends MemoryStats {
    private final int freePercent;
    private final int usedPercent;
    public static final JsonpDeserializer<ExtendedMemoryStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ExtendedMemoryStats::setupExtendedMemoryStatsDeserializer);

    private ExtendedMemoryStats(Builder builder) {
        super(builder);
        this.freePercent = ApiTypeHelper.requireNonNull(builder.freePercent, this, "freePercent");
        this.usedPercent = ApiTypeHelper.requireNonNull(builder.usedPercent, this, "usedPercent");
    }

    public static ExtendedMemoryStats of(Function<Builder, ObjectBuilder<ExtendedMemoryStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int freePercent() {
        return this.freePercent;
    }

    public final int usedPercent() {
        return this.usedPercent;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("free_percent");
        generator.write(this.freePercent);
        generator.writeKey("used_percent");
        generator.write(this.usedPercent);
    }

    protected static void setupExtendedMemoryStatsDeserializer(ObjectDeserializer<Builder> op) {
        MemoryStats.setupMemoryStatsDeserializer(op);
        op.add(Builder::freePercent, JsonpDeserializer.integerDeserializer(), "free_percent");
        op.add(Builder::usedPercent, JsonpDeserializer.integerDeserializer(), "used_percent");
    }

    public static class Builder
    extends MemoryStats.AbstractBuilder<Builder>
    implements ObjectBuilder<ExtendedMemoryStats> {
        private Integer freePercent;
        private Integer usedPercent;

        public final Builder freePercent(int value) {
            this.freePercent = value;
            return this;
        }

        public final Builder usedPercent(int value) {
            this.usedPercent = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ExtendedMemoryStats build() {
            this._checkSingleUse();
            return new ExtendedMemoryStats(this);
        }
    }
}

