/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.TotalFeatureImportanceStatistics;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class TotalFeatureImportanceClass
implements JsonpSerializable {
    private final String className;
    private final List<TotalFeatureImportanceStatistics> importance;
    public static final JsonpDeserializer<TotalFeatureImportanceClass> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TotalFeatureImportanceClass::setupTotalFeatureImportanceClassDeserializer);

    private TotalFeatureImportanceClass(Builder builder) {
        this.className = ApiTypeHelper.requireNonNull(builder.className, this, "className");
        this.importance = ApiTypeHelper.unmodifiableRequired(builder.importance, (Object)this, "importance");
    }

    public static TotalFeatureImportanceClass of(Function<Builder, ObjectBuilder<TotalFeatureImportanceClass>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String className() {
        return this.className;
    }

    public final List<TotalFeatureImportanceStatistics> importance() {
        return this.importance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("class_name");
        generator.write(this.className);
        if (ApiTypeHelper.isDefined(this.importance)) {
            generator.writeKey("importance");
            generator.writeStartArray();
            for (TotalFeatureImportanceStatistics item0 : this.importance) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupTotalFeatureImportanceClassDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::className, JsonpDeserializer.stringDeserializer(), "class_name");
        op.add(Builder::importance, JsonpDeserializer.arrayDeserializer(TotalFeatureImportanceStatistics._DESERIALIZER), "importance");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<TotalFeatureImportanceClass> {
        private String className;
        private List<TotalFeatureImportanceStatistics> importance;

        public final Builder className(String value) {
            this.className = value;
            return this;
        }

        public final Builder importance(List<TotalFeatureImportanceStatistics> list) {
            this.importance = Builder._listAddAll(this.importance, list);
            return this;
        }

        public final Builder importance(TotalFeatureImportanceStatistics value, TotalFeatureImportanceStatistics ... values) {
            this.importance = Builder._listAdd(this.importance, value, values);
            return this;
        }

        public final Builder importance(Function<TotalFeatureImportanceStatistics.Builder, ObjectBuilder<TotalFeatureImportanceStatistics>> fn) {
            return this.importance(fn.apply(new TotalFeatureImportanceStatistics.Builder()).build(), new TotalFeatureImportanceStatistics[0]);
        }

        @Override
        public TotalFeatureImportanceClass build() {
            this._checkSingleUse();
            return new TotalFeatureImportanceClass(this);
        }
    }
}

