/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ingest;

import co.elastic.clients.ApiClient;
import co.elastic.clients.elasticsearch._types.ElasticsearchException;
import co.elastic.clients.elasticsearch.ingest.DeletePipelineRequest;
import co.elastic.clients.elasticsearch.ingest.DeletePipelineResponse;
import co.elastic.clients.elasticsearch.ingest.GeoIpStatsRequest;
import co.elastic.clients.elasticsearch.ingest.GeoIpStatsResponse;
import co.elastic.clients.elasticsearch.ingest.GetPipelineRequest;
import co.elastic.clients.elasticsearch.ingest.GetPipelineResponse;
import co.elastic.clients.elasticsearch.ingest.ProcessorGrokRequest;
import co.elastic.clients.elasticsearch.ingest.ProcessorGrokResponse;
import co.elastic.clients.elasticsearch.ingest.PutPipelineRequest;
import co.elastic.clients.elasticsearch.ingest.PutPipelineResponse;
import co.elastic.clients.elasticsearch.ingest.SimulateRequest;
import co.elastic.clients.elasticsearch.ingest.SimulateResponse;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.JsonEndpoint;
import co.elastic.clients.transport.TransportOptions;
import co.elastic.clients.util.ObjectBuilder;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;

public class ElasticsearchIngestAsyncClient
extends ApiClient<ElasticsearchTransport, ElasticsearchIngestAsyncClient> {
    public ElasticsearchIngestAsyncClient(ElasticsearchTransport transport) {
        super(transport, null);
    }

    public ElasticsearchIngestAsyncClient(ElasticsearchTransport transport, @Nullable TransportOptions transportOptions) {
        super(transport, transportOptions);
    }

    @Override
    public ElasticsearchIngestAsyncClient withTransportOptions(@Nullable TransportOptions transportOptions) {
        return new ElasticsearchIngestAsyncClient((ElasticsearchTransport)this.transport, transportOptions);
    }

    public CompletableFuture<DeletePipelineResponse> deletePipeline(DeletePipelineRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)DeletePipelineRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<DeletePipelineResponse> deletePipeline(Function<DeletePipelineRequest.Builder, ObjectBuilder<DeletePipelineRequest>> fn) throws IOException, ElasticsearchException {
        return this.deletePipeline(fn.apply(new DeletePipelineRequest.Builder()).build());
    }

    public CompletableFuture<GeoIpStatsResponse> geoIpStats() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(GeoIpStatsRequest._INSTANCE, GeoIpStatsRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<GetPipelineResponse> getPipeline(GetPipelineRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)GetPipelineRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<GetPipelineResponse> getPipeline(Function<GetPipelineRequest.Builder, ObjectBuilder<GetPipelineRequest>> fn) throws IOException, ElasticsearchException {
        return this.getPipeline(fn.apply(new GetPipelineRequest.Builder()).build());
    }

    public CompletableFuture<GetPipelineResponse> getPipeline() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new GetPipelineRequest.Builder().build(), GetPipelineRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<ProcessorGrokResponse> processorGrok() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(ProcessorGrokRequest._INSTANCE, ProcessorGrokRequest._ENDPOINT, this.transportOptions);
    }

    public CompletableFuture<PutPipelineResponse> putPipeline(PutPipelineRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)PutPipelineRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<PutPipelineResponse> putPipeline(Function<PutPipelineRequest.Builder, ObjectBuilder<PutPipelineRequest>> fn) throws IOException, ElasticsearchException {
        return this.putPipeline(fn.apply(new PutPipelineRequest.Builder()).build());
    }

    public CompletableFuture<SimulateResponse> simulate(SimulateRequest request) throws IOException, ElasticsearchException {
        JsonEndpoint endpoint = (JsonEndpoint)SimulateRequest._ENDPOINT;
        return ((ElasticsearchTransport)this.transport).performRequestAsync(request, endpoint, this.transportOptions);
    }

    public final CompletableFuture<SimulateResponse> simulate(Function<SimulateRequest.Builder, ObjectBuilder<SimulateRequest>> fn) throws IOException, ElasticsearchException {
        return this.simulate(fn.apply(new SimulateRequest.Builder()).build());
    }

    public CompletableFuture<SimulateResponse> simulate() throws IOException, ElasticsearchException {
        return ((ElasticsearchTransport)this.transport).performRequestAsync(new SimulateRequest.Builder().build(), SimulateRequest._ENDPOINT, this.transportOptions);
    }
}

