/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices.analyze;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class CharFilterDetail
implements JsonpSerializable {
    private final List<String> filteredText;
    private final String name;
    public static final JsonpDeserializer<CharFilterDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CharFilterDetail::setupCharFilterDetailDeserializer);

    private CharFilterDetail(Builder builder) {
        this.filteredText = ApiTypeHelper.unmodifiableRequired(builder.filteredText, (Object)this, "filteredText");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
    }

    public static CharFilterDetail of(Function<Builder, ObjectBuilder<CharFilterDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> filteredText() {
        return this.filteredText;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.filteredText)) {
            generator.writeKey("filtered_text");
            generator.writeStartArray();
            for (String item0 : this.filteredText) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        generator.writeKey("name");
        generator.write(this.name);
    }

    protected static void setupCharFilterDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::filteredText, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "filtered_text");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<CharFilterDetail> {
        private List<String> filteredText;
        private String name;

        public final Builder filteredText(List<String> list) {
            this.filteredText = Builder._listAddAll(this.filteredText, list);
            return this;
        }

        public final Builder filteredText(String value, String ... values) {
            this.filteredText = Builder._listAdd(this.filteredText, value, values);
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        @Override
        public CharFilterDetail build() {
            this._checkSingleUse();
            return new CharFilterDetail(this);
        }
    }
}

