/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.SuggestOption;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public class Suggestion<T>
implements JsonpSerializable {
    private final int length;
    private final int offset;
    private final List<SuggestOption<T>> options;
    private final String text;
    @Nullable
    private final JsonpSerializer<T> tSerializer;

    private Suggestion(Builder<T> builder) {
        this.length = ApiTypeHelper.requireNonNull(((Builder)builder).length, this, "length");
        this.offset = ApiTypeHelper.requireNonNull(((Builder)builder).offset, this, "offset");
        this.options = ApiTypeHelper.unmodifiableRequired(((Builder)builder).options, (Object)this, "options");
        this.text = ApiTypeHelper.requireNonNull(((Builder)builder).text, this, "text");
        this.tSerializer = ((Builder)builder).tSerializer;
    }

    public static <T> Suggestion<T> of(Function<Builder<T>, ObjectBuilder<Suggestion<T>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final int length() {
        return this.length;
    }

    public final int offset() {
        return this.offset;
    }

    public final List<SuggestOption<T>> options() {
        return this.options;
    }

    public final String text() {
        return this.text;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("length");
        generator.write(this.length);
        generator.writeKey("offset");
        generator.write(this.offset);
        if (ApiTypeHelper.isDefined(this.options)) {
            generator.writeKey("options");
            generator.writeStartArray();
            for (SuggestOption<T> item0 : this.options) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("text");
        generator.write(this.text);
    }

    public static <T> JsonpDeserializer<Suggestion<T>> createSuggestionDeserializer(JsonpDeserializer<T> tDeserializer) {
        return ObjectBuilderDeserializer.createForObject(Builder::new, op -> Suggestion.setupSuggestionDeserializer(op, tDeserializer));
    }

    protected static <T> void setupSuggestionDeserializer(ObjectDeserializer<Builder<T>> op, JsonpDeserializer<T> tDeserializer) {
        op.add(Builder::length, JsonpDeserializer.integerDeserializer(), "length");
        op.add(Builder::offset, JsonpDeserializer.integerDeserializer(), "offset");
        op.add(Builder::options, JsonpDeserializer.arrayDeserializer(SuggestOption.createSuggestOptionDeserializer(tDeserializer)), "options");
        op.add(Builder::text, JsonpDeserializer.stringDeserializer(), "text");
    }

    public static class Builder<T>
    extends ObjectBuilderBase
    implements ObjectBuilder<Suggestion<T>> {
        private Integer length;
        private Integer offset;
        private List<SuggestOption<T>> options;
        private String text;
        @Nullable
        private JsonpSerializer<T> tSerializer;

        public final Builder<T> length(int value) {
            this.length = value;
            return this;
        }

        public final Builder<T> offset(int value) {
            this.offset = value;
            return this;
        }

        public final Builder<T> options(List<SuggestOption<T>> list) {
            this.options = Builder._listAddAll(this.options, list);
            return this;
        }

        public final Builder<T> options(SuggestOption<T> value, SuggestOption<T> ... values) {
            this.options = Builder._listAdd(this.options, value, values);
            return this;
        }

        public final Builder<T> options(Function<SuggestOption.Builder<T>, ObjectBuilder<SuggestOption<T>>> fn) {
            return this.options(fn.apply(new SuggestOption.Builder()).build(), new SuggestOption[0]);
        }

        public final Builder<T> text(String value) {
            this.text = value;
            return this;
        }

        public final Builder<T> tSerializer(@Nullable JsonpSerializer<T> value) {
            this.tSerializer = value;
            return this;
        }

        @Override
        public Suggestion<T> build() {
            this._checkSingleUse();
            return new Suggestion(this);
        }
    }
}

