/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core;

import co.elastic.clients.elasticsearch._types.ElasticsearchVersionInfo;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class InfoResponse
implements JsonpSerializable {
    private final String clusterName;
    private final String clusterUuid;
    private final String name;
    private final String tagline;
    private final ElasticsearchVersionInfo version;
    public static final JsonpDeserializer<InfoResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InfoResponse::setupInfoResponseDeserializer);

    private InfoResponse(Builder builder) {
        this.clusterName = ApiTypeHelper.requireNonNull(builder.clusterName, this, "clusterName");
        this.clusterUuid = ApiTypeHelper.requireNonNull(builder.clusterUuid, this, "clusterUuid");
        this.name = ApiTypeHelper.requireNonNull(builder.name, this, "name");
        this.tagline = ApiTypeHelper.requireNonNull(builder.tagline, this, "tagline");
        this.version = ApiTypeHelper.requireNonNull(builder.version, this, "version");
    }

    public static InfoResponse of(Function<Builder, ObjectBuilder<InfoResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String clusterUuid() {
        return this.clusterUuid;
    }

    public final String name() {
        return this.name;
    }

    public final String tagline() {
        return this.tagline;
    }

    public final ElasticsearchVersionInfo version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("cluster_uuid");
        generator.write(this.clusterUuid);
        generator.writeKey("name");
        generator.write(this.name);
        generator.writeKey("tagline");
        generator.write(this.tagline);
        generator.writeKey("version");
        this.version.serialize(generator, mapper);
    }

    protected static void setupInfoResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name");
        op.add(Builder::clusterUuid, JsonpDeserializer.stringDeserializer(), "cluster_uuid");
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name");
        op.add(Builder::tagline, JsonpDeserializer.stringDeserializer(), "tagline");
        op.add(Builder::version, ElasticsearchVersionInfo._DESERIALIZER, "version");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<InfoResponse> {
        private String clusterName;
        private String clusterUuid;
        private String name;
        private String tagline;
        private ElasticsearchVersionInfo version;

        public final Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public final Builder clusterUuid(String value) {
            this.clusterUuid = value;
            return this;
        }

        public final Builder name(String value) {
            this.name = value;
            return this;
        }

        public final Builder tagline(String value) {
            this.tagline = value;
            return this;
        }

        public final Builder version(ElasticsearchVersionInfo value) {
            this.version = value;
            return this;
        }

        public final Builder version(Function<ElasticsearchVersionInfo.Builder, ObjectBuilder<ElasticsearchVersionInfo>> fn) {
            return this.version(fn.apply(new ElasticsearchVersionInfo.Builder()).build());
        }

        @Override
        public InfoResponse build() {
            this._checkSingleUse();
            return new InfoResponse(this);
        }
    }
}

