/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class GeoLine
implements JsonpSerializable {
    private final String type;
    private final List<List<Double>> coordinates;
    public static final JsonpDeserializer<GeoLine> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoLine::setupGeoLineDeserializer);

    private GeoLine(Builder builder) {
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.coordinates = ApiTypeHelper.unmodifiableRequired(builder.coordinates, (Object)this, "coordinates");
    }

    public static GeoLine of(Function<Builder, ObjectBuilder<GeoLine>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String type() {
        return this.type;
    }

    public final List<List<Double>> coordinates() {
        return this.coordinates;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("type");
        generator.write(this.type);
        if (ApiTypeHelper.isDefined(this.coordinates)) {
            generator.writeKey("coordinates");
            generator.writeStartArray();
            for (List<Double> item0 : this.coordinates) {
                generator.writeStartArray();
                if (item0 != null) {
                    for (Double item1 : item0) {
                        generator.write(item1.doubleValue());
                    }
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupGeoLineDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::coordinates, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.arrayDeserializer(JsonpDeserializer.doubleDeserializer())), "coordinates");
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<GeoLine> {
        private String type;
        private List<List<Double>> coordinates;

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder coordinates(List<List<Double>> list) {
            this.coordinates = Builder._listAddAll(this.coordinates, list);
            return this;
        }

        public final Builder coordinates(List<Double> value, List<Double> ... values) {
            this.coordinates = Builder._listAdd(this.coordinates, value, values);
            return this;
        }

        @Override
        public GeoLine build() {
            this._checkSingleUse();
            return new GeoLine(this);
        }
    }
}

