/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ErrorCause
implements JsonpSerializable {
    private final Map<String, JsonData> metadata;
    private final String type;
    private final String reason;
    @Nullable
    private final String stackTrace;
    @Nullable
    private final ErrorCause causedBy;
    private final List<ErrorCause> rootCause;
    private final List<ErrorCause> suppressed;
    public static final JsonpDeserializer<ErrorCause> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ErrorCause::setupErrorCauseDeserializer);

    private ErrorCause(Builder builder) {
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.type = ApiTypeHelper.requireNonNull(builder.type, this, "type");
        this.reason = ApiTypeHelper.requireNonNull(builder.reason, this, "reason");
        this.stackTrace = builder.stackTrace;
        this.causedBy = builder.causedBy;
        this.rootCause = ApiTypeHelper.unmodifiable(builder.rootCause);
        this.suppressed = ApiTypeHelper.unmodifiable(builder.suppressed);
    }

    public static ErrorCause of(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    public final String type() {
        return this.type;
    }

    public final String reason() {
        return this.reason;
    }

    @Nullable
    public final String stackTrace() {
        return this.stackTrace;
    }

    @Nullable
    public final ErrorCause causedBy() {
        return this.causedBy;
    }

    public final List<ErrorCause> rootCause() {
        return this.rootCause;
    }

    public final List<ErrorCause> suppressed() {
        return this.suppressed;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        for (Map.Entry<String, JsonData> entry : this.metadata.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeKey("type");
        generator.write(this.type);
        generator.writeKey("reason");
        generator.write(this.reason);
        if (this.stackTrace != null) {
            generator.writeKey("stack_trace");
            generator.write(this.stackTrace);
        }
        if (this.causedBy != null) {
            generator.writeKey("caused_by");
            this.causedBy.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.rootCause)) {
            generator.writeKey("root_cause");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.rootCause) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.suppressed)) {
            generator.writeKey("suppressed");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.suppressed) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupErrorCauseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::type, JsonpDeserializer.stringDeserializer(), "type");
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason");
        op.add(Builder::stackTrace, JsonpDeserializer.stringDeserializer(), "stack_trace");
        op.add(Builder::causedBy, _DESERIALIZER, "caused_by");
        op.add(Builder::rootCause, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "root_cause");
        op.add(Builder::suppressed, JsonpDeserializer.arrayDeserializer(_DESERIALIZER), "suppressed");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            if (((Builder)builder).metadata == null) {
                ((Builder)builder).metadata = new HashMap();
            }
            ((Builder)builder).metadata.put(name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<ErrorCause> {
        @Nullable
        private Map<String, JsonData> metadata = new HashMap<String, JsonData>();
        private String type;
        private String reason;
        @Nullable
        private String stackTrace;
        @Nullable
        private ErrorCause causedBy;
        @Nullable
        private List<ErrorCause> rootCause;
        @Nullable
        private List<ErrorCause> suppressed;

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder type(String value) {
            this.type = value;
            return this;
        }

        public final Builder reason(String value) {
            this.reason = value;
            return this;
        }

        public final Builder stackTrace(@Nullable String value) {
            this.stackTrace = value;
            return this;
        }

        public final Builder causedBy(@Nullable ErrorCause value) {
            this.causedBy = value;
            return this;
        }

        public final Builder causedBy(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.causedBy(fn.apply(new Builder()).build());
        }

        public final Builder rootCause(List<ErrorCause> list) {
            this.rootCause = Builder._listAddAll(this.rootCause, list);
            return this;
        }

        public final Builder rootCause(ErrorCause value, ErrorCause ... values) {
            this.rootCause = Builder._listAdd(this.rootCause, value, values);
            return this;
        }

        public final Builder rootCause(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.rootCause(fn.apply(new Builder()).build(), new ErrorCause[0]);
        }

        public final Builder suppressed(List<ErrorCause> list) {
            this.suppressed = Builder._listAddAll(this.suppressed, list);
            return this;
        }

        public final Builder suppressed(ErrorCause value, ErrorCause ... values) {
            this.suppressed = Builder._listAdd(this.suppressed, value, values);
            return this;
        }

        public final Builder suppressed(Function<Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.suppressed(fn.apply(new Builder()).build(), new ErrorCause[0]);
        }

        @Override
        public ErrorCause build() {
            this._checkSingleUse();
            return new ErrorCause(this);
        }
    }
}

