/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json;

import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.UnexpectedJsonEventException;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParsingException;
import java.io.Reader;
import java.io.StringReader;
import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class JsonpUtils {
    public static JsonParser.Event expectNextEvent(JsonParser parser, JsonParser.Event expected) {
        JsonParser.Event event = parser.next();
        JsonpUtils.expectEvent(parser, expected, event);
        return event;
    }

    public static void expectEvent(JsonParser parser, JsonParser.Event expected, JsonParser.Event event) {
        if (event != expected) {
            throw new UnexpectedJsonEventException(parser, event, expected);
        }
    }

    public static String expectKeyName(JsonParser parser, JsonParser.Event event) {
        JsonpUtils.expectEvent(parser, JsonParser.Event.KEY_NAME, event);
        return parser.getString();
    }

    public static void skipValue(JsonParser parser) {
        JsonpUtils.skipValue(parser, parser.next());
    }

    public static void skipValue(JsonParser parser, JsonParser.Event event) {
        switch (event) {
            case START_OBJECT: {
                parser.skipObject();
                break;
            }
            case START_ARRAY: {
                parser.skipArray();
                break;
            }
        }
    }

    public static void unknownKey(JsonParser parser, String keyName) {
        throw new JsonParsingException("Unknown property " + keyName, parser.getLocation());
    }

    public static String ensureSingleVariant(JsonParser parser, String variant1, String variant2) {
        if (variant1 != null && variant2 != null) {
            throw new JsonParsingException("Only one variant can be specified, found '" + variant1 + "' and '" + variant2 + "'", parser.getLocation());
        }
        return variant2;
    }

    public static <T> T buildVariant(JsonParser parser, ObjectBuilder<T> builder) {
        if (builder == null) {
            throw new JsonParsingException("No variant found", parser.getLocation());
        }
        return builder.build();
    }

    public static <T> void serialize(T value, JsonGenerator generator, @Nullable JsonpSerializer<T> serializer, JsonpMapper mapper) {
        if (serializer != null) {
            serializer.serialize(value, generator, mapper);
        } else if (value instanceof JsonpSerializable) {
            ((JsonpSerializable)value).serialize(generator, mapper);
        } else {
            mapper.serialize(value, generator);
        }
    }

    public static Map.Entry<String, JsonParser> lookAheadFieldValue(String name, JsonParser parser, JsonpMapper mapper) {
        JsonObject object = parser.getObject();
        String result = object.getString(name, null);
        if (result == null) {
            throw new JsonParsingException("Property '" + name + "' not found", parser.getLocation());
        }
        String strObject = object.toString();
        JsonParser newParser = mapper.jsonProvider().createParser((Reader)new StringReader(strObject));
        return new AbstractMap.SimpleImmutableEntry<String, JsonParser>(result, newParser);
    }

    public static String toString(JsonValue value) {
        switch (value.getValueType()) {
            case OBJECT: {
                throw new IllegalArgumentException("Json objects cannot be used as string");
            }
            case ARRAY: {
                return value.asJsonArray().stream().map(JsonpUtils::toString).collect(Collectors.joining(","));
            }
            case STRING: {
                return ((JsonString)value).getString();
            }
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case NULL: {
                return "null";
            }
            case NUMBER: {
                return value.toString();
            }
        }
        throw new IllegalArgumentException("Unknown json value type: " + value);
    }
}

