/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ml.JobStatistics;
import co.elastic.clients.elasticsearch.xpack.usage.MlCounter;
import co.elastic.clients.elasticsearch.xpack.usage.MlInferenceTrainedModelsCount;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class MlInferenceTrainedModels
implements JsonpSerializable {
    @Nullable
    private final JobStatistics estimatedOperations;
    @Nullable
    private final JobStatistics estimatedHeapMemoryUsageBytes;
    @Nullable
    private final MlInferenceTrainedModelsCount count;
    private final MlCounter all;
    public static final JsonpDeserializer<MlInferenceTrainedModels> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MlInferenceTrainedModels::setupMlInferenceTrainedModelsDeserializer, Builder::build);

    public MlInferenceTrainedModels(Builder builder) {
        this.estimatedOperations = builder.estimatedOperations;
        this.estimatedHeapMemoryUsageBytes = builder.estimatedHeapMemoryUsageBytes;
        this.count = builder.count;
        this.all = Objects.requireNonNull(builder.all, "_all");
    }

    public MlInferenceTrainedModels(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public JobStatistics estimatedOperations() {
        return this.estimatedOperations;
    }

    @Nullable
    public JobStatistics estimatedHeapMemoryUsageBytes() {
        return this.estimatedHeapMemoryUsageBytes;
    }

    @Nullable
    public MlInferenceTrainedModelsCount count() {
        return this.count;
    }

    public MlCounter all() {
        return this.all;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.estimatedOperations != null) {
            generator.writeKey("estimated_operations");
            this.estimatedOperations.serialize(generator, mapper);
        }
        if (this.estimatedHeapMemoryUsageBytes != null) {
            generator.writeKey("estimated_heap_memory_usage_bytes");
            this.estimatedHeapMemoryUsageBytes.serialize(generator, mapper);
        }
        if (this.count != null) {
            generator.writeKey("count");
            this.count.serialize(generator, mapper);
        }
        generator.writeKey("_all");
        this.all.serialize(generator, mapper);
    }

    protected static void setupMlInferenceTrainedModelsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::estimatedOperations, JobStatistics._DESERIALIZER, "estimated_operations", new String[0]);
        op.add(Builder::estimatedHeapMemoryUsageBytes, JobStatistics._DESERIALIZER, "estimated_heap_memory_usage_bytes", new String[0]);
        op.add(Builder::count, MlInferenceTrainedModelsCount._DESERIALIZER, "count", new String[0]);
        op.add(Builder::all, MlCounter._DESERIALIZER, "_all", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MlInferenceTrainedModels> {
        @Nullable
        private JobStatistics estimatedOperations;
        @Nullable
        private JobStatistics estimatedHeapMemoryUsageBytes;
        @Nullable
        private MlInferenceTrainedModelsCount count;
        private MlCounter all;

        public Builder estimatedOperations(@Nullable JobStatistics value) {
            this.estimatedOperations = value;
            return this;
        }

        public Builder estimatedOperations(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.estimatedOperations(fn.apply(new JobStatistics.Builder()).build());
        }

        public Builder estimatedHeapMemoryUsageBytes(@Nullable JobStatistics value) {
            this.estimatedHeapMemoryUsageBytes = value;
            return this;
        }

        public Builder estimatedHeapMemoryUsageBytes(Function<JobStatistics.Builder, ObjectBuilder<JobStatistics>> fn) {
            return this.estimatedHeapMemoryUsageBytes(fn.apply(new JobStatistics.Builder()).build());
        }

        public Builder count(@Nullable MlInferenceTrainedModelsCount value) {
            this.count = value;
            return this;
        }

        public Builder count(Function<MlInferenceTrainedModelsCount.Builder, ObjectBuilder<MlInferenceTrainedModelsCount>> fn) {
            return this.count(fn.apply(new MlInferenceTrainedModelsCount.Builder()).build());
        }

        public Builder all(MlCounter value) {
            this.all = value;
            return this;
        }

        public Builder all(Function<MlCounter.Builder, ObjectBuilder<MlCounter>> fn) {
            return this.all(fn.apply(new MlCounter.Builder()).build());
        }

        @Override
        public MlInferenceTrainedModels build() {
            return new MlInferenceTrainedModels(this);
        }
    }
}

