/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.xpack.usage;

import co.elastic.clients.elasticsearch.ml.Job;
import co.elastic.clients.elasticsearch.xpack.usage.Base;
import co.elastic.clients.elasticsearch.xpack.usage.Datafeed;
import co.elastic.clients.elasticsearch.xpack.usage.MlDataFrameAnalyticsJobs;
import co.elastic.clients.elasticsearch.xpack.usage.MlInference;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MachineLearning
extends Base {
    private final Map<String, Datafeed> datafeeds;
    private final Map<String, Job> jobs;
    private final int nodeCount;
    private final MlDataFrameAnalyticsJobs dataFrameAnalyticsJobs;
    private final MlInference inference;
    public static final JsonpDeserializer<MachineLearning> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MachineLearning::setupMachineLearningDeserializer, Builder::build);

    public MachineLearning(Builder builder) {
        super(builder);
        this.datafeeds = ModelTypeHelper.unmodifiableNonNull(builder.datafeeds, "datafeeds");
        this.jobs = ModelTypeHelper.unmodifiableNonNull(builder.jobs, "jobs");
        this.nodeCount = Objects.requireNonNull(builder.nodeCount, "node_count");
        this.dataFrameAnalyticsJobs = Objects.requireNonNull(builder.dataFrameAnalyticsJobs, "data_frame_analytics_jobs");
        this.inference = Objects.requireNonNull(builder.inference, "inference");
    }

    public MachineLearning(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, Datafeed> datafeeds() {
        return this.datafeeds;
    }

    public Map<String, Job> jobs() {
        return this.jobs;
    }

    public int nodeCount() {
        return this.nodeCount;
    }

    public MlDataFrameAnalyticsJobs dataFrameAnalyticsJobs() {
        return this.dataFrameAnalyticsJobs;
    }

    public MlInference inference() {
        return this.inference;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        generator.writeKey("datafeeds");
        generator.writeStartObject();
        for (Map.Entry<String, Datafeed> entry : this.datafeeds.entrySet()) {
            generator.writeKey(entry.getKey());
            entry.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("jobs");
        generator.writeStartObject();
        for (Map.Entry<String, JsonpSerializable> entry : this.jobs.entrySet()) {
            generator.writeKey(entry.getKey());
            ((Job)entry.getValue()).serialize(generator, mapper);
        }
        generator.writeEnd();
        generator.writeKey("node_count");
        generator.write(this.nodeCount);
        generator.writeKey("data_frame_analytics_jobs");
        this.dataFrameAnalyticsJobs.serialize(generator, mapper);
        generator.writeKey("inference");
        this.inference.serialize(generator, mapper);
    }

    protected static void setupMachineLearningDeserializer(DelegatingDeserializer<Builder> op) {
        Base.setupBaseDeserializer(op);
        op.add(Builder::datafeeds, JsonpDeserializer.stringMapDeserializer(Datafeed._DESERIALIZER), "datafeeds", new String[0]);
        op.add(Builder::jobs, JsonpDeserializer.stringMapDeserializer(Job._DESERIALIZER), "jobs", new String[0]);
        op.add(Builder::nodeCount, JsonpDeserializer.integerDeserializer(), "node_count", new String[0]);
        op.add(Builder::dataFrameAnalyticsJobs, MlDataFrameAnalyticsJobs._DESERIALIZER, "data_frame_analytics_jobs", new String[0]);
        op.add(Builder::inference, MlInference._DESERIALIZER, "inference", new String[0]);
    }

    public static class Builder
    extends Base.AbstractBuilder<Builder>
    implements ObjectBuilder<MachineLearning> {
        private Map<String, Datafeed> datafeeds;
        private Map<String, Job> jobs;
        private Integer nodeCount;
        private MlDataFrameAnalyticsJobs dataFrameAnalyticsJobs;
        private MlInference inference;

        public Builder datafeeds(Map<String, Datafeed> value) {
            this.datafeeds = value;
            return this;
        }

        public Builder putDatafeeds(String key, Datafeed value) {
            if (this.datafeeds == null) {
                this.datafeeds = new HashMap<String, Datafeed>();
            }
            this.datafeeds.put(key, value);
            return this;
        }

        public Builder datafeeds(String key, Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.datafeeds(Collections.singletonMap(key, fn.apply(new Datafeed.Builder()).build()));
        }

        public Builder putDatafeeds(String key, Function<Datafeed.Builder, ObjectBuilder<Datafeed>> fn) {
            return this.putDatafeeds(key, fn.apply(new Datafeed.Builder()).build());
        }

        public Builder jobs(Map<String, Job> value) {
            this.jobs = value;
            return this;
        }

        public Builder putJobs(String key, Job value) {
            if (this.jobs == null) {
                this.jobs = new HashMap<String, Job>();
            }
            this.jobs.put(key, value);
            return this;
        }

        public Builder jobs(String key, Function<Job.Builder, ObjectBuilder<Job>> fn) {
            return this.jobs(Collections.singletonMap(key, fn.apply(new Job.Builder()).build()));
        }

        public Builder putJobs(String key, Function<Job.Builder, ObjectBuilder<Job>> fn) {
            return this.putJobs(key, fn.apply(new Job.Builder()).build());
        }

        public Builder nodeCount(int value) {
            this.nodeCount = value;
            return this;
        }

        public Builder dataFrameAnalyticsJobs(MlDataFrameAnalyticsJobs value) {
            this.dataFrameAnalyticsJobs = value;
            return this;
        }

        public Builder dataFrameAnalyticsJobs(Function<MlDataFrameAnalyticsJobs.Builder, ObjectBuilder<MlDataFrameAnalyticsJobs>> fn) {
            return this.dataFrameAnalyticsJobs(fn.apply(new MlDataFrameAnalyticsJobs.Builder()).build());
        }

        public Builder inference(MlInference value) {
            this.inference = value;
            return this;
        }

        public Builder inference(Function<MlInference.Builder, ObjectBuilder<MlInference>> fn) {
            return this.inference(fn.apply(new MlInference.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public MachineLearning build() {
            return new MachineLearning(this);
        }
    }
}

