/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class EmailResult
implements JsonpSerializable {
    @Nullable
    private final String account;
    private final EmailResult message;
    @Nullable
    private final String reason;
    public static final JsonpDeserializer<EmailResult> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EmailResult::setupEmailResultDeserializer, Builder::build);

    public EmailResult(Builder builder) {
        this.account = builder.account;
        this.message = Objects.requireNonNull(builder.message, "message");
        this.reason = builder.reason;
    }

    public EmailResult(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String account() {
        return this.account;
    }

    public EmailResult message() {
        return this.message;
    }

    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.account != null) {
            generator.writeKey("account");
            generator.write(this.account);
        }
        generator.writeKey("message");
        this.message.serialize(generator, mapper);
        if (this.reason != null) {
            generator.writeKey("reason");
            generator.write(this.reason);
        }
    }

    protected static void setupEmailResultDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::account, JsonpDeserializer.stringDeserializer(), "account", new String[0]);
        op.add(Builder::message, _DESERIALIZER, "message", new String[0]);
        op.add(Builder::reason, JsonpDeserializer.stringDeserializer(), "reason", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<EmailResult> {
        @Nullable
        private String account;
        private EmailResult message;
        @Nullable
        private String reason;

        public Builder account(@Nullable String value) {
            this.account = value;
            return this;
        }

        public Builder message(EmailResult value) {
            this.message = value;
            return this;
        }

        public Builder message(Function<Builder, ObjectBuilder<EmailResult>> fn) {
            return this.message(fn.apply(new Builder()).build());
        }

        public Builder reason(@Nullable String value) {
            this.reason = value;
            return this;
        }

        @Override
        public EmailResult build() {
            return new EmailResult(this);
        }
    }
}

