/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch._types.Transform;
import co.elastic.clients.elasticsearch.watcher.ActionType;
import co.elastic.clients.elasticsearch.watcher.ActionWebhook;
import co.elastic.clients.elasticsearch.watcher.Condition;
import co.elastic.clients.elasticsearch.watcher.Index;
import co.elastic.clients.elasticsearch.watcher.Logging;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class Action
implements JsonpSerializable {
    @Nullable
    private final ActionType actionType;
    @Nullable
    private final Condition condition;
    @Nullable
    private final String foreach;
    @Nullable
    private final Integer maxIterations;
    @Nullable
    private final String name;
    @Nullable
    private final String throttlePeriod;
    @Nullable
    private final String throttlePeriodInMillis;
    @Nullable
    private final Transform transform;
    @Nullable
    private final Index index;
    @Nullable
    private final Logging logging;
    @Nullable
    private final ActionWebhook webhook;
    public static final JsonpDeserializer<Action> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Action::setupActionDeserializer, Builder::build);

    public Action(Builder builder) {
        this.actionType = builder.actionType;
        this.condition = builder.condition;
        this.foreach = builder.foreach;
        this.maxIterations = builder.maxIterations;
        this.name = builder.name;
        this.throttlePeriod = builder.throttlePeriod;
        this.throttlePeriodInMillis = builder.throttlePeriodInMillis;
        this.transform = builder.transform;
        this.index = builder.index;
        this.logging = builder.logging;
        this.webhook = builder.webhook;
    }

    public Action(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public ActionType actionType() {
        return this.actionType;
    }

    @Nullable
    public Condition condition() {
        return this.condition;
    }

    @Nullable
    public String foreach() {
        return this.foreach;
    }

    @Nullable
    public Integer maxIterations() {
        return this.maxIterations;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public String throttlePeriod() {
        return this.throttlePeriod;
    }

    @Nullable
    public String throttlePeriodInMillis() {
        return this.throttlePeriodInMillis;
    }

    @Nullable
    public Transform transform() {
        return this.transform;
    }

    @Nullable
    public Index index() {
        return this.index;
    }

    @Nullable
    public Logging logging() {
        return this.logging;
    }

    @Nullable
    public ActionWebhook webhook() {
        return this.webhook;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.actionType != null) {
            generator.writeKey("action_type");
            this.actionType.serialize(generator, mapper);
        }
        if (this.condition != null) {
            generator.writeKey("condition");
            this.condition.serialize(generator, mapper);
        }
        if (this.foreach != null) {
            generator.writeKey("foreach");
            generator.write(this.foreach);
        }
        if (this.maxIterations != null) {
            generator.writeKey("max_iterations");
            generator.write(this.maxIterations.intValue());
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.throttlePeriod != null) {
            generator.writeKey("throttle_period");
            generator.write(this.throttlePeriod);
        }
        if (this.throttlePeriodInMillis != null) {
            generator.writeKey("throttle_period_in_millis");
            generator.write(this.throttlePeriodInMillis);
        }
        if (this.transform != null) {
            generator.writeKey("transform");
            this.transform.serialize(generator, mapper);
        }
        if (this.index != null) {
            generator.writeKey("index");
            this.index.serialize(generator, mapper);
        }
        if (this.logging != null) {
            generator.writeKey("logging");
            this.logging.serialize(generator, mapper);
        }
        if (this.webhook != null) {
            generator.writeKey("webhook");
            this.webhook.serialize(generator, mapper);
        }
    }

    protected static void setupActionDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::actionType, ActionType._DESERIALIZER, "action_type", new String[0]);
        op.add(Builder::condition, Condition._DESERIALIZER, "condition", new String[0]);
        op.add(Builder::foreach, JsonpDeserializer.stringDeserializer(), "foreach", new String[0]);
        op.add(Builder::maxIterations, JsonpDeserializer.integerDeserializer(), "max_iterations", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::throttlePeriod, JsonpDeserializer.stringDeserializer(), "throttle_period", new String[0]);
        op.add(Builder::throttlePeriodInMillis, JsonpDeserializer.stringDeserializer(), "throttle_period_in_millis", new String[0]);
        op.add(Builder::transform, Transform._DESERIALIZER, "transform", new String[0]);
        op.add(Builder::index, Index._DESERIALIZER, "index", new String[0]);
        op.add(Builder::logging, Logging._DESERIALIZER, "logging", new String[0]);
        op.add(Builder::webhook, ActionWebhook._DESERIALIZER, "webhook", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Action> {
        @Nullable
        private ActionType actionType;
        @Nullable
        private Condition condition;
        @Nullable
        private String foreach;
        @Nullable
        private Integer maxIterations;
        @Nullable
        private String name;
        @Nullable
        private String throttlePeriod;
        @Nullable
        private String throttlePeriodInMillis;
        @Nullable
        private Transform transform;
        @Nullable
        private Index index;
        @Nullable
        private Logging logging;
        @Nullable
        private ActionWebhook webhook;

        public Builder actionType(@Nullable ActionType value) {
            this.actionType = value;
            return this;
        }

        public Builder condition(@Nullable Condition value) {
            this.condition = value;
            return this;
        }

        public Builder condition(Function<Condition.Builder, ObjectBuilder<Condition>> fn) {
            return this.condition(fn.apply(new Condition.Builder()).build());
        }

        public Builder foreach(@Nullable String value) {
            this.foreach = value;
            return this;
        }

        public Builder maxIterations(@Nullable Integer value) {
            this.maxIterations = value;
            return this;
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder throttlePeriod(@Nullable String value) {
            this.throttlePeriod = value;
            return this;
        }

        public Builder throttlePeriodInMillis(@Nullable String value) {
            this.throttlePeriodInMillis = value;
            return this;
        }

        public Builder transform(@Nullable Transform value) {
            this.transform = value;
            return this;
        }

        public Builder transform(Function<Transform.Builder, ObjectBuilder<Transform>> fn) {
            return this.transform(fn.apply(new Transform.Builder()).build());
        }

        public Builder index(@Nullable Index value) {
            this.index = value;
            return this;
        }

        public Builder index(Function<Index.Builder, ObjectBuilder<Index>> fn) {
            return this.index(fn.apply(new Index.Builder()).build());
        }

        public Builder logging(@Nullable Logging value) {
            this.logging = value;
            return this;
        }

        public Builder logging(Function<Logging.Builder, ObjectBuilder<Logging>> fn) {
            return this.logging(fn.apply(new Logging.Builder()).build());
        }

        public Builder webhook(@Nullable ActionWebhook value) {
            this.webhook = value;
            return this;
        }

        public Builder webhook(Function<ActionWebhook.Builder, ObjectBuilder<ActionWebhook>> fn) {
            return this.webhook(fn.apply(new ActionWebhook.Builder()).build());
        }

        @Override
        public Action build() {
            return new Action(this);
        }
    }
}

