/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.watcher;

import co.elastic.clients.elasticsearch.watcher.AcknowledgementOptions;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class AcknowledgeState
implements JsonpSerializable {
    private final AcknowledgementOptions state;
    private final String timestamp;
    public static final JsonpDeserializer<AcknowledgeState> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AcknowledgeState::setupAcknowledgeStateDeserializer, Builder::build);

    public AcknowledgeState(Builder builder) {
        this.state = Objects.requireNonNull(builder.state, "state");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public AcknowledgeState(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public AcknowledgementOptions state() {
        return this.state;
    }

    public String timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("state");
        this.state.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupAcknowledgeStateDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::state, AcknowledgementOptions._DESERIALIZER, "state", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.stringDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<AcknowledgeState> {
        private AcknowledgementOptions state;
        private String timestamp;

        public Builder state(AcknowledgementOptions value) {
            this.state = value;
            return this;
        }

        public Builder timestamp(String value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public AcknowledgeState build() {
            return new AcknowledgeState(this);
        }
    }
}

