/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class Latest
implements JsonpSerializable {
    private final String sort;
    private final List<String> uniqueKey;
    public static final JsonpDeserializer<Latest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Latest::setupLatestDeserializer, Builder::build);

    public Latest(Builder builder) {
        this.sort = Objects.requireNonNull(builder.sort, "sort");
        this.uniqueKey = ModelTypeHelper.unmodifiableNonNull(builder.uniqueKey, "unique_key");
    }

    public Latest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String sort() {
        return this.sort;
    }

    public List<String> uniqueKey() {
        return this.uniqueKey;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("sort");
        generator.write(this.sort);
        generator.writeKey("unique_key");
        generator.writeStartArray();
        for (String item0 : this.uniqueKey) {
            generator.write(item0);
        }
        generator.writeEnd();
    }

    protected static void setupLatestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::sort, JsonpDeserializer.stringDeserializer(), "sort", new String[0]);
        op.add(Builder::uniqueKey, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "unique_key", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<Latest> {
        private String sort;
        private List<String> uniqueKey;

        public Builder sort(String value) {
            this.sort = value;
            return this;
        }

        public Builder uniqueKey(List<String> value) {
            this.uniqueKey = value;
            return this;
        }

        public Builder uniqueKey(String ... value) {
            this.uniqueKey = Arrays.asList(value);
            return this;
        }

        public Builder addUniqueKey(String value) {
            if (this.uniqueKey == null) {
                this.uniqueKey = new ArrayList<String>();
            }
            this.uniqueKey.add(value);
            return this;
        }

        @Override
        public Latest build() {
            return new Latest(this);
        }
    }
}

