/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.transform;

import co.elastic.clients.elasticsearch.transform.get_transform_stats.TransformStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class GetTransformStatsResponse
implements JsonpSerializable {
    private final long count;
    private final List<TransformStats> transforms;
    public static final JsonpDeserializer<GetTransformStatsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetTransformStatsResponse::setupGetTransformStatsResponseDeserializer, Builder::build);

    public GetTransformStatsResponse(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.transforms = ModelTypeHelper.unmodifiableNonNull(builder.transforms, "transforms");
    }

    public GetTransformStatsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public List<TransformStats> transforms() {
        return this.transforms;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("transforms");
        generator.writeStartArray();
        for (TransformStats item0 : this.transforms) {
            item0.serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupGetTransformStatsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::transforms, JsonpDeserializer.arrayDeserializer(TransformStats._DESERIALIZER), "transforms", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetTransformStatsResponse> {
        private Long count;
        private List<TransformStats> transforms;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder transforms(List<TransformStats> value) {
            this.transforms = value;
            return this;
        }

        public Builder transforms(TransformStats ... value) {
            this.transforms = Arrays.asList(value);
            return this;
        }

        public Builder addTransforms(TransformStats value) {
            if (this.transforms == null) {
                this.transforms = new ArrayList<TransformStats>();
            }
            this.transforms.add(value);
            return this;
        }

        public Builder transforms(Function<TransformStats.Builder, ObjectBuilder<TransformStats>> fn) {
            return this.transforms(fn.apply(new TransformStats.Builder()).build());
        }

        public Builder addTransforms(Function<TransformStats.Builder, ObjectBuilder<TransformStats>> fn) {
            return this.addTransforms(fn.apply(new TransformStats.Builder()).build());
        }

        @Override
        public GetTransformStatsResponse build() {
            return new GetTransformStatsResponse(this);
        }
    }
}

