/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure.find_structure;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TopHit
implements JsonpSerializable {
    private final long count;
    private final JsonData value;
    public static final JsonpDeserializer<TopHit> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TopHit::setupTopHitDeserializer, Builder::build);

    public TopHit(Builder builder) {
        this.count = Objects.requireNonNull(builder.count, "count");
        this.value = Objects.requireNonNull(builder.value, "value");
    }

    public TopHit(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long count() {
        return this.count;
    }

    public JsonData value() {
        return this.value;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        generator.writeKey("value");
        this.value.serialize(generator, mapper);
    }

    protected static void setupTopHitDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count", new String[0]);
        op.add(Builder::value, JsonData._DESERIALIZER, "value", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TopHit> {
        private Long count;
        private JsonData value;

        public Builder count(long value) {
            this.count = value;
            return this;
        }

        public Builder value(JsonData value) {
            this.value = value;
            return this;
        }

        @Override
        public TopHit build() {
            return new TopHit(this);
        }
    }
}

