/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.text_structure;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch.text_structure.FindStructureResponse;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpSerializer;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class FindStructureRequest<TJsonDocument>
implements JsonpSerializable {
    @Nullable
    private final String charset;
    @Nullable
    private final String columnNames;
    @Nullable
    private final String delimiter;
    @Nullable
    private final Boolean explain;
    @Nullable
    private final String format;
    @Nullable
    private final String grokPattern;
    @Nullable
    private final Boolean hasHeaderRow;
    @Nullable
    private final Number lineMergeSizeLimit;
    @Nullable
    private final Number linesToSample;
    @Nullable
    private final String quote;
    @Nullable
    private final Boolean shouldTrimFields;
    @Nullable
    private final String timeout;
    @Nullable
    private final String timestampField;
    @Nullable
    private final String timestampFormat;
    private final List<TJsonDocument> textFiles;
    @Nullable
    private final JsonpSerializer<TJsonDocument> tJsonDocumentSerializer;
    public static final Endpoint<FindStructureRequest<?>, FindStructureResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<FindStructureRequest, FindStructureResponse>(request -> "POST", request -> "/_text_structure/find_structure", request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.charset != null) {
            params.put("charset", request.charset);
        }
        if (request.columnNames != null) {
            params.put("column_names", request.columnNames);
        }
        if (request.delimiter != null) {
            params.put("delimiter", request.delimiter);
        }
        if (request.explain != null) {
            params.put("explain", String.valueOf(request.explain));
        }
        if (request.format != null) {
            params.put("format", request.format);
        }
        if (request.grokPattern != null) {
            params.put("grok_pattern", request.grokPattern);
        }
        if (request.hasHeaderRow != null) {
            params.put("has_header_row", String.valueOf(request.hasHeaderRow));
        }
        if (request.lineMergeSizeLimit != null) {
            params.put("line_merge_size_limit", request.lineMergeSizeLimit.toString());
        }
        if (request.linesToSample != null) {
            params.put("lines_to_sample", request.linesToSample.toString());
        }
        if (request.quote != null) {
            params.put("quote", request.quote);
        }
        if (request.shouldTrimFields != null) {
            params.put("should_trim_fields", String.valueOf(request.shouldTrimFields));
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.timestampField != null) {
            params.put("timestamp_field", request.timestampField);
        }
        if (request.timestampFormat != null) {
            params.put("timestamp_format", request.timestampFormat);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, FindStructureResponse._DESERIALIZER);

    public FindStructureRequest(Builder<TJsonDocument> builder) {
        this.charset = ((Builder)builder).charset;
        this.columnNames = ((Builder)builder).columnNames;
        this.delimiter = ((Builder)builder).delimiter;
        this.explain = ((Builder)builder).explain;
        this.format = ((Builder)builder).format;
        this.grokPattern = ((Builder)builder).grokPattern;
        this.hasHeaderRow = ((Builder)builder).hasHeaderRow;
        this.lineMergeSizeLimit = ((Builder)builder).lineMergeSizeLimit;
        this.linesToSample = ((Builder)builder).linesToSample;
        this.quote = ((Builder)builder).quote;
        this.shouldTrimFields = ((Builder)builder).shouldTrimFields;
        this.timeout = ((Builder)builder).timeout;
        this.timestampField = ((Builder)builder).timestampField;
        this.timestampFormat = ((Builder)builder).timestampFormat;
        this.textFiles = ModelTypeHelper.unmodifiableNonNull(((Builder)builder).textFiles, "_value_body");
        this.tJsonDocumentSerializer = ((Builder)builder).tJsonDocumentSerializer;
    }

    public FindStructureRequest(Function<Builder<TJsonDocument>, Builder<TJsonDocument>> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String charset() {
        return this.charset;
    }

    @Nullable
    public String columnNames() {
        return this.columnNames;
    }

    @Nullable
    public String delimiter() {
        return this.delimiter;
    }

    @Nullable
    public Boolean explain() {
        return this.explain;
    }

    @Nullable
    public String format() {
        return this.format;
    }

    @Nullable
    public String grokPattern() {
        return this.grokPattern;
    }

    @Nullable
    public Boolean hasHeaderRow() {
        return this.hasHeaderRow;
    }

    @Nullable
    public Number lineMergeSizeLimit() {
        return this.lineMergeSizeLimit;
    }

    @Nullable
    public Number linesToSample() {
        return this.linesToSample;
    }

    @Nullable
    public String quote() {
        return this.quote;
    }

    @Nullable
    public Boolean shouldTrimFields() {
        return this.shouldTrimFields;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public String timestampField() {
        return this.timestampField;
    }

    @Nullable
    public String timestampFormat() {
        return this.timestampFormat;
    }

    public List<TJsonDocument> textFiles() {
        return this.textFiles;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartArray();
        for (TJsonDocument item0 : this.textFiles) {
            JsonpUtils.serialize(item0, generator, this.tJsonDocumentSerializer, mapper);
        }
        generator.writeEnd();
    }

    public static <TJsonDocument> JsonpDeserializer<FindStructureRequest<TJsonDocument>> createFindStructureRequestDeserializer(JsonpDeserializer<TJsonDocument> tJsonDocumentDeserializer) {
        JsonpDeserializer valueDeserializer = JsonpDeserializer.arrayDeserializer(tJsonDocumentDeserializer);
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().textFiles((List)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder<TJsonDocument>
    implements ObjectBuilder<FindStructureRequest<TJsonDocument>> {
        @Nullable
        private String charset;
        @Nullable
        private String columnNames;
        @Nullable
        private String delimiter;
        @Nullable
        private Boolean explain;
        @Nullable
        private String format;
        @Nullable
        private String grokPattern;
        @Nullable
        private Boolean hasHeaderRow;
        @Nullable
        private Number lineMergeSizeLimit;
        @Nullable
        private Number linesToSample;
        @Nullable
        private String quote;
        @Nullable
        private Boolean shouldTrimFields;
        @Nullable
        private String timeout;
        @Nullable
        private String timestampField;
        @Nullable
        private String timestampFormat;
        private List<TJsonDocument> textFiles;
        @Nullable
        private JsonpSerializer<TJsonDocument> tJsonDocumentSerializer;

        public Builder<TJsonDocument> charset(@Nullable String value) {
            this.charset = value;
            return this;
        }

        public Builder<TJsonDocument> columnNames(@Nullable String value) {
            this.columnNames = value;
            return this;
        }

        public Builder<TJsonDocument> delimiter(@Nullable String value) {
            this.delimiter = value;
            return this;
        }

        public Builder<TJsonDocument> explain(@Nullable Boolean value) {
            this.explain = value;
            return this;
        }

        public Builder<TJsonDocument> format(@Nullable String value) {
            this.format = value;
            return this;
        }

        public Builder<TJsonDocument> grokPattern(@Nullable String value) {
            this.grokPattern = value;
            return this;
        }

        public Builder<TJsonDocument> hasHeaderRow(@Nullable Boolean value) {
            this.hasHeaderRow = value;
            return this;
        }

        public Builder<TJsonDocument> lineMergeSizeLimit(@Nullable Number value) {
            this.lineMergeSizeLimit = value;
            return this;
        }

        public Builder<TJsonDocument> linesToSample(@Nullable Number value) {
            this.linesToSample = value;
            return this;
        }

        public Builder<TJsonDocument> quote(@Nullable String value) {
            this.quote = value;
            return this;
        }

        public Builder<TJsonDocument> shouldTrimFields(@Nullable Boolean value) {
            this.shouldTrimFields = value;
            return this;
        }

        public Builder<TJsonDocument> timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder<TJsonDocument> timestampField(@Nullable String value) {
            this.timestampField = value;
            return this;
        }

        public Builder<TJsonDocument> timestampFormat(@Nullable String value) {
            this.timestampFormat = value;
            return this;
        }

        public Builder<TJsonDocument> textFiles(List<TJsonDocument> value) {
            this.textFiles = value;
            return this;
        }

        public Builder<TJsonDocument> textFiles(TJsonDocument ... value) {
            this.textFiles = Arrays.asList(value);
            return this;
        }

        public Builder<TJsonDocument> addTextFiles(TJsonDocument value) {
            if (this.textFiles == null) {
                this.textFiles = new ArrayList<TJsonDocument>();
            }
            this.textFiles.add(value);
            return this;
        }

        public Builder<TJsonDocument> tJsonDocumentSerializer(@Nullable JsonpSerializer<TJsonDocument> value) {
            this.tJsonDocumentSerializer = value;
            return this;
        }

        @Override
        public FindStructureRequest<TJsonDocument> build() {
            return new FindStructureRequest(this);
        }
    }
}

