/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.elasticsearch._types.ErrorCause;
import co.elastic.clients.elasticsearch.tasks.TaskExecutingNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class ListResponse
implements JsonpSerializable {
    @Nullable
    private final List<ErrorCause> nodeFailures;
    @Nullable
    private final Map<String, TaskExecutingNode> nodes;
    @Nullable
    private final JsonValue tasks;
    public static final JsonpDeserializer<ListResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ListResponse::setupListResponseDeserializer, Builder::build);

    public ListResponse(AbstractBuilder<?> builder) {
        this.nodeFailures = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).nodeFailures);
        this.nodes = ModelTypeHelper.unmodifiable(((AbstractBuilder)builder).nodes);
        this.tasks = ((AbstractBuilder)builder).tasks;
    }

    @Nullable
    public List<ErrorCause> nodeFailures() {
        return this.nodeFailures;
    }

    @Nullable
    public Map<String, TaskExecutingNode> nodes() {
        return this.nodes;
    }

    @Nullable
    public JsonValue tasks() {
        return this.tasks;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.nodeFailures != null) {
            generator.writeKey("node_failures");
            generator.writeStartArray();
            for (ErrorCause errorCause : this.nodeFailures) {
                errorCause.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.nodes != null) {
            generator.writeKey("nodes");
            generator.writeStartObject();
            for (Map.Entry entry : this.nodes.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((TaskExecutingNode)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tasks != null) {
            generator.writeKey("tasks");
            generator.write(this.tasks);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupListResponseDeserializer(DelegatingDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::nodeFailures, JsonpDeserializer.arrayDeserializer(ErrorCause._DESERIALIZER), "node_failures", new String[0]);
        op.add(AbstractBuilder::nodes, JsonpDeserializer.stringMapDeserializer(TaskExecutingNode._DESERIALIZER), "nodes", new String[0]);
        op.add(AbstractBuilder::tasks, JsonpDeserializer.jsonValueDeserializer(), "tasks", new String[0]);
    }

    protected static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>> {
        @Nullable
        private List<ErrorCause> nodeFailures;
        @Nullable
        private Map<String, TaskExecutingNode> nodes;
        @Nullable
        private JsonValue tasks;

        protected AbstractBuilder() {
        }

        public BuilderT nodeFailures(@Nullable List<ErrorCause> value) {
            this.nodeFailures = value;
            return this.self();
        }

        public BuilderT nodeFailures(ErrorCause ... value) {
            this.nodeFailures = Arrays.asList(value);
            return this.self();
        }

        public BuilderT addNodeFailures(ErrorCause value) {
            if (this.nodeFailures == null) {
                this.nodeFailures = new ArrayList<ErrorCause>();
            }
            this.nodeFailures.add(value);
            return this.self();
        }

        public BuilderT nodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.nodeFailures(fn.apply(new ErrorCause.Builder()).build());
        }

        public BuilderT addNodeFailures(Function<ErrorCause.Builder, ObjectBuilder<ErrorCause>> fn) {
            return this.addNodeFailures(fn.apply(new ErrorCause.Builder()).build());
        }

        public BuilderT nodes(@Nullable Map<String, TaskExecutingNode> value) {
            this.nodes = value;
            return this.self();
        }

        public BuilderT putNodes(String key, TaskExecutingNode value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, TaskExecutingNode>();
            }
            this.nodes.put(key, value);
            return this.self();
        }

        public BuilderT nodes(String key, Function<TaskExecutingNode.Builder, ObjectBuilder<TaskExecutingNode>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new TaskExecutingNode.Builder()).build()));
        }

        public BuilderT putNodes(String key, Function<TaskExecutingNode.Builder, ObjectBuilder<TaskExecutingNode>> fn) {
            return this.putNodes(key, fn.apply(new TaskExecutingNode.Builder()).build());
        }

        public BuilderT tasks(@Nullable JsonValue value) {
            this.tasks = value;
            return this.self();
        }

        protected abstract BuilderT self();
    }

    public static class Builder
    extends AbstractBuilder<Builder>
    implements ObjectBuilder<ListResponse> {
        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ListResponse build() {
            return new ListResponse(this);
        }
    }
}

