/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.tasks;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.tasks.CancelResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class CancelRequest
extends RequestBase {
    @Nullable
    private final String taskId;
    @Nullable
    private final List<String> actions;
    @Nullable
    private final List<String> nodes;
    @Nullable
    private final String parentTaskId;
    @Nullable
    private final Boolean waitForCompletion;
    public static final Endpoint<CancelRequest, CancelResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<CancelRequest, CancelResponse>(request -> "POST", request -> {
        boolean _taskId = true;
        boolean propsSet = false;
        if (request.taskId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_tasks");
            buf.append("/_cancel");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_tasks");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskId, buf);
            buf.append("/_cancel");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.actions != null) {
            params.put("actions", request.actions.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.nodes != null) {
            params.put("nodes", request.nodes.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.parentTaskId != null) {
            params.put("parent_task_id", request.parentTaskId);
        }
        if (request.waitForCompletion != null) {
            params.put("wait_for_completion", String.valueOf(request.waitForCompletion));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, CancelResponse._DESERIALIZER);

    public CancelRequest(Builder builder) {
        this.taskId = builder.taskId;
        this.actions = ModelTypeHelper.unmodifiable(builder.actions);
        this.nodes = ModelTypeHelper.unmodifiable(builder.nodes);
        this.parentTaskId = builder.parentTaskId;
        this.waitForCompletion = builder.waitForCompletion;
    }

    public CancelRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String taskId() {
        return this.taskId;
    }

    @Nullable
    public List<String> actions() {
        return this.actions;
    }

    @Nullable
    public List<String> nodes() {
        return this.nodes;
    }

    @Nullable
    public String parentTaskId() {
        return this.parentTaskId;
    }

    @Nullable
    public Boolean waitForCompletion() {
        return this.waitForCompletion;
    }

    public static class Builder
    implements ObjectBuilder<CancelRequest> {
        @Nullable
        private String taskId;
        @Nullable
        private List<String> actions;
        @Nullable
        private List<String> nodes;
        @Nullable
        private String parentTaskId;
        @Nullable
        private Boolean waitForCompletion;

        public Builder taskId(@Nullable String value) {
            this.taskId = value;
            return this;
        }

        public Builder actions(@Nullable List<String> value) {
            this.actions = value;
            return this;
        }

        public Builder actions(String ... value) {
            this.actions = Arrays.asList(value);
            return this;
        }

        public Builder addActions(String value) {
            if (this.actions == null) {
                this.actions = new ArrayList<String>();
            }
            this.actions.add(value);
            return this;
        }

        public Builder nodes(@Nullable List<String> value) {
            this.nodes = value;
            return this;
        }

        public Builder nodes(String ... value) {
            this.nodes = Arrays.asList(value);
            return this;
        }

        public Builder addNodes(String value) {
            if (this.nodes == null) {
                this.nodes = new ArrayList<String>();
            }
            this.nodes.add(value);
            return this;
        }

        public Builder parentTaskId(@Nullable String value) {
            this.parentTaskId = value;
            return this;
        }

        public Builder waitForCompletion(@Nullable Boolean value) {
            this.waitForCompletion = value;
            return this;
        }

        @Override
        public CancelRequest build() {
            return new CancelRequest(this);
        }
    }
}

