/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot.cleanup_repository;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class CleanupRepositoryResults
implements JsonpSerializable {
    private final long deletedBlobs;
    private final long deletedBytes;
    public static final JsonpDeserializer<CleanupRepositoryResults> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CleanupRepositoryResults::setupCleanupRepositoryResultsDeserializer, Builder::build);

    public CleanupRepositoryResults(Builder builder) {
        this.deletedBlobs = Objects.requireNonNull(builder.deletedBlobs, "deleted_blobs");
        this.deletedBytes = Objects.requireNonNull(builder.deletedBytes, "deleted_bytes");
    }

    public CleanupRepositoryResults(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long deletedBlobs() {
        return this.deletedBlobs;
    }

    public long deletedBytes() {
        return this.deletedBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("deleted_blobs");
        generator.write(this.deletedBlobs);
        generator.writeKey("deleted_bytes");
        generator.write(this.deletedBytes);
    }

    protected static void setupCleanupRepositoryResultsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::deletedBlobs, JsonpDeserializer.longDeserializer(), "deleted_blobs", new String[0]);
        op.add(Builder::deletedBytes, JsonpDeserializer.longDeserializer(), "deleted_bytes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<CleanupRepositoryResults> {
        private Long deletedBlobs;
        private Long deletedBytes;

        public Builder deletedBlobs(long value) {
            this.deletedBlobs = value;
            return this;
        }

        public Builder deletedBytes(long value) {
            this.deletedBytes = value;
            return this;
        }

        @Override
        public CleanupRepositoryResults build() {
            return new CleanupRepositoryResults(this);
        }
    }
}

