/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.StatusResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class StatusRequest
extends RequestBase {
    @Nullable
    private final String repository;
    @Nullable
    private final List<String> snapshot;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final String masterTimeout;
    public static final Endpoint<StatusRequest, StatusResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StatusRequest, StatusResponse>(request -> "GET", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        if (request.repository() != null) {
            propsSet |= 1;
        }
        if (request.snapshot() != null) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/_status");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/_status");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_status");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StatusResponse._DESERIALIZER);

    public StatusRequest(Builder builder) {
        this.repository = builder.repository;
        this.snapshot = ModelTypeHelper.unmodifiable(builder.snapshot);
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.masterTimeout = builder.masterTimeout;
    }

    public StatusRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String repository() {
        return this.repository;
    }

    @Nullable
    public List<String> snapshot() {
        return this.snapshot;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    public static class Builder
    implements ObjectBuilder<StatusRequest> {
        @Nullable
        private String repository;
        @Nullable
        private List<String> snapshot;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private String masterTimeout;

        public Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public Builder snapshot(@Nullable List<String> value) {
            this.snapshot = value;
            return this;
        }

        public Builder snapshot(String ... value) {
            this.snapshot = Arrays.asList(value);
            return this;
        }

        public Builder addSnapshot(String value) {
            if (this.snapshot == null) {
                this.snapshot = new ArrayList<String>();
            }
            this.snapshot.add(value);
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        @Override
        public StatusRequest build() {
            return new StatusRequest(this);
        }
    }
}

