/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.snapshot.DeleteRepositoryResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class DeleteRepositoryRequest
extends RequestBase {
    private final List<String> repository;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    public static final Endpoint<DeleteRepositoryRequest, DeleteRepositoryResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<DeleteRepositoryRequest, DeleteRepositoryResponse>(request -> "DELETE", request -> {
        boolean _repository = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, DeleteRepositoryResponse._DESERIALIZER);

    public DeleteRepositoryRequest(Builder builder) {
        this.repository = ModelTypeHelper.unmodifiableNonNull(builder.repository, "repository");
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
    }

    public DeleteRepositoryRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public List<String> repository() {
        return this.repository;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    public static class Builder
    implements ObjectBuilder<DeleteRepositoryRequest> {
        private List<String> repository;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;

        public Builder repository(List<String> value) {
            this.repository = value;
            return this;
        }

        public Builder repository(String ... value) {
            this.repository = Arrays.asList(value);
            return this;
        }

        public Builder addRepository(String value) {
            if (this.repository == null) {
                this.repository = new ArrayList<String>();
            }
            this.repository.add(value);
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        @Override
        public DeleteRepositoryRequest build() {
            return new DeleteRepositoryRequest(this);
        }
    }
}

