/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.grant_api_key;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class ApiKey
implements JsonpSerializable {
    private final String name;
    @Nullable
    private final String expiration;
    @Nullable
    private final List<Map<String, JsonData>> roleDescriptors;
    public static final JsonpDeserializer<ApiKey> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ApiKey::setupApiKeyDeserializer, Builder::build);

    public ApiKey(Builder builder) {
        this.name = Objects.requireNonNull(builder.name, "name");
        this.expiration = builder.expiration;
        this.roleDescriptors = ModelTypeHelper.unmodifiable(builder.roleDescriptors);
    }

    public ApiKey(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public String expiration() {
        return this.expiration;
    }

    @Nullable
    public List<Map<String, JsonData>> roleDescriptors() {
        return this.roleDescriptors;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("name");
        generator.write(this.name);
        if (this.expiration != null) {
            generator.writeKey("expiration");
            generator.write(this.expiration);
        }
        if (this.roleDescriptors != null) {
            generator.writeKey("role_descriptors");
            generator.writeStartArray();
            for (Map<String, JsonData> item0 : this.roleDescriptors) {
                generator.writeStartObject();
                for (Map.Entry<String, JsonData> item1 : item0.entrySet()) {
                    generator.writeKey(item1.getKey());
                    item1.getValue().serialize(generator, mapper);
                }
                generator.writeEnd();
            }
            generator.writeEnd();
        }
    }

    protected static void setupApiKeyDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::expiration, JsonpDeserializer.stringDeserializer(), "expiration", new String[0]);
        op.add(Builder::roleDescriptors, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER)), "role_descriptors", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ApiKey> {
        private String name;
        @Nullable
        private String expiration;
        @Nullable
        private List<Map<String, JsonData>> roleDescriptors;

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder expiration(@Nullable String value) {
            this.expiration = value;
            return this;
        }

        public Builder roleDescriptors(@Nullable List<Map<String, JsonData>> value) {
            this.roleDescriptors = value;
            return this;
        }

        public Builder roleDescriptors(Map<String, JsonData> ... value) {
            this.roleDescriptors = Arrays.asList(value);
            return this;
        }

        public Builder addRoleDescriptors(Map<String, JsonData> value) {
            if (this.roleDescriptors == null) {
                this.roleDescriptors = new ArrayList<Map<String, JsonData>>();
            }
            this.roleDescriptors.add(value);
            return this;
        }

        @Override
        public ApiKey build() {
            return new ApiKey(this);
        }
    }
}

