/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.security.InvalidateApiKeyResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class InvalidateApiKeyRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final String id;
    @Nullable
    private final List<String> ids;
    @Nullable
    private final String name;
    @Nullable
    private final Boolean owner;
    @Nullable
    private final String realmName;
    @Nullable
    private final String username;
    public static final JsonpDeserializer<InvalidateApiKeyRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InvalidateApiKeyRequest::setupInvalidateApiKeyRequestDeserializer, Builder::build);
    public static final Endpoint<InvalidateApiKeyRequest, InvalidateApiKeyResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<InvalidateApiKeyRequest, InvalidateApiKeyResponse>(request -> "DELETE", request -> "/_security/api_key", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, InvalidateApiKeyResponse._DESERIALIZER);

    public InvalidateApiKeyRequest(Builder builder) {
        this.id = builder.id;
        this.ids = ModelTypeHelper.unmodifiable(builder.ids);
        this.name = builder.name;
        this.owner = builder.owner;
        this.realmName = builder.realmName;
        this.username = builder.username;
    }

    public InvalidateApiKeyRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String id() {
        return this.id;
    }

    @Nullable
    public List<String> ids() {
        return this.ids;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    @Nullable
    public Boolean owner() {
        return this.owner;
    }

    @Nullable
    public String realmName() {
        return this.realmName;
    }

    @Nullable
    public String username() {
        return this.username;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.id != null) {
            generator.writeKey("id");
            generator.write(this.id);
        }
        if (this.ids != null) {
            generator.writeKey("ids");
            generator.writeStartArray();
            for (String item0 : this.ids) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.name != null) {
            generator.writeKey("name");
            generator.write(this.name);
        }
        if (this.owner != null) {
            generator.writeKey("owner");
            generator.write(this.owner.booleanValue());
        }
        if (this.realmName != null) {
            generator.writeKey("realm_name");
            generator.write(this.realmName);
        }
        if (this.username != null) {
            generator.writeKey("username");
            generator.write(this.username);
        }
    }

    protected static void setupInvalidateApiKeyRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id", new String[0]);
        op.add(Builder::ids, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "ids", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::owner, JsonpDeserializer.booleanDeserializer(), "owner", new String[0]);
        op.add(Builder::realmName, JsonpDeserializer.stringDeserializer(), "realm_name", new String[0]);
        op.add(Builder::username, JsonpDeserializer.stringDeserializer(), "username", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<InvalidateApiKeyRequest> {
        @Nullable
        private String id;
        @Nullable
        private List<String> ids;
        @Nullable
        private String name;
        @Nullable
        private Boolean owner;
        @Nullable
        private String realmName;
        @Nullable
        private String username;

        public Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        public Builder ids(@Nullable List<String> value) {
            this.ids = value;
            return this;
        }

        public Builder ids(String ... value) {
            this.ids = Arrays.asList(value);
            return this;
        }

        public Builder addIds(String value) {
            if (this.ids == null) {
                this.ids = new ArrayList<String>();
            }
            this.ids.add(value);
            return this;
        }

        public Builder name(@Nullable String value) {
            this.name = value;
            return this;
        }

        public Builder owner(@Nullable Boolean value) {
            this.owner = value;
            return this;
        }

        public Builder realmName(@Nullable String value) {
            this.realmName = value;
            return this;
        }

        public Builder username(@Nullable String value) {
            this.username = value;
            return this;
        }

        @Override
        public InvalidateApiKeyRequest build() {
            return new InvalidateApiKeyRequest(this);
        }
    }
}

