/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security;

import co.elastic.clients.elasticsearch._types.NodeStatistics;
import co.elastic.clients.elasticsearch.security.ClusterNode;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ClearCachedRealmsResponse
implements JsonpSerializable {
    private final NodeStatistics nodeStats;
    private final String clusterName;
    private final Map<String, ClusterNode> nodes;
    public static final JsonpDeserializer<ClearCachedRealmsResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ClearCachedRealmsResponse::setupClearCachedRealmsResponseDeserializer, Builder::build);

    public ClearCachedRealmsResponse(Builder builder) {
        this.nodeStats = Objects.requireNonNull(builder.nodeStats, "_nodes");
        this.clusterName = Objects.requireNonNull(builder.clusterName, "cluster_name");
        this.nodes = ModelTypeHelper.unmodifiableNonNull(builder.nodes, "nodes");
    }

    public ClearCachedRealmsResponse(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public NodeStatistics nodeStats() {
        return this.nodeStats;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public Map<String, ClusterNode> nodes() {
        return this.nodes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("_nodes");
        this.nodeStats.serialize(generator, mapper);
        generator.writeKey("cluster_name");
        generator.write(this.clusterName);
        generator.writeKey("nodes");
        generator.writeStartObject();
        for (Map.Entry<String, ClusterNode> item0 : this.nodes.entrySet()) {
            generator.writeKey(item0.getKey());
            item0.getValue().serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    protected static void setupClearCachedRealmsResponseDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::nodeStats, NodeStatistics._DESERIALIZER, "_nodes", new String[0]);
        op.add(Builder::clusterName, JsonpDeserializer.stringDeserializer(), "cluster_name", new String[0]);
        op.add(Builder::nodes, JsonpDeserializer.stringMapDeserializer(ClusterNode._DESERIALIZER), "nodes", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<ClearCachedRealmsResponse> {
        private NodeStatistics nodeStats;
        private String clusterName;
        private Map<String, ClusterNode> nodes;

        public Builder nodeStats(NodeStatistics value) {
            this.nodeStats = value;
            return this;
        }

        public Builder nodeStats(Function<NodeStatistics.Builder, ObjectBuilder<NodeStatistics>> fn) {
            return this.nodeStats(fn.apply(new NodeStatistics.Builder()).build());
        }

        public Builder clusterName(String value) {
            this.clusterName = value;
            return this;
        }

        public Builder nodes(Map<String, ClusterNode> value) {
            this.nodes = value;
            return this;
        }

        public Builder putNodes(String key, ClusterNode value) {
            if (this.nodes == null) {
                this.nodes = new HashMap<String, ClusterNode>();
            }
            this.nodes.put(key, value);
            return this;
        }

        public Builder nodes(String key, Function<ClusterNode.Builder, ObjectBuilder<ClusterNode>> fn) {
            return this.nodes(Collections.singletonMap(key, fn.apply(new ClusterNode.Builder()).build()));
        }

        public Builder putNodes(String key, Function<ClusterNode.Builder, ObjectBuilder<ClusterNode>> fn) {
            return this.putNodes(key, fn.apply(new ClusterNode.Builder()).build());
        }

        @Override
        public ClearCachedRealmsResponse build() {
            return new ClearCachedRealmsResponse(this);
        }
    }
}

