/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots.mount;

import co.elastic.clients.elasticsearch._types.ShardStatistics;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class MountedSnapshot
implements JsonpSerializable {
    private final String snapshot;
    private final List<String> indices;
    private final ShardStatistics shards;
    public static final JsonpDeserializer<MountedSnapshot> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, MountedSnapshot::setupMountedSnapshotDeserializer, Builder::build);

    public MountedSnapshot(Builder builder) {
        this.snapshot = Objects.requireNonNull(builder.snapshot, "snapshot");
        this.indices = ModelTypeHelper.unmodifiableNonNull(builder.indices, "indices");
        this.shards = Objects.requireNonNull(builder.shards, "shards");
    }

    public MountedSnapshot(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String snapshot() {
        return this.snapshot;
    }

    public List<String> indices() {
        return this.indices;
    }

    public ShardStatistics shards() {
        return this.shards;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("snapshot");
        generator.write(this.snapshot);
        generator.writeKey("indices");
        generator.writeStartArray();
        for (String item0 : this.indices) {
            generator.write(item0);
        }
        generator.writeEnd();
        generator.writeKey("shards");
        this.shards.serialize(generator, mapper);
    }

    protected static void setupMountedSnapshotDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::snapshot, JsonpDeserializer.stringDeserializer(), "snapshot", new String[0]);
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "indices", new String[0]);
        op.add(Builder::shards, ShardStatistics._DESERIALIZER, "shards", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<MountedSnapshot> {
        private String snapshot;
        private List<String> indices;
        private ShardStatistics shards;

        public Builder snapshot(String value) {
            this.snapshot = value;
            return this;
        }

        public Builder indices(List<String> value) {
            this.indices = value;
            return this;
        }

        public Builder indices(String ... value) {
            this.indices = Arrays.asList(value);
            return this;
        }

        public Builder addIndices(String value) {
            if (this.indices == null) {
                this.indices = new ArrayList<String>();
            }
            this.indices.add(value);
            return this;
        }

        public Builder shards(ShardStatistics value) {
            this.shards = value;
            return this;
        }

        public Builder shards(Function<ShardStatistics.Builder, ObjectBuilder<ShardStatistics>> fn) {
            return this.shards(fn.apply(new ShardStatistics.Builder()).build());
        }

        @Override
        public MountedSnapshot build() {
            return new MountedSnapshot(this);
        }
    }
}

