/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.searchable_snapshots;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.ExpandWildcardOptions;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.searchable_snapshots.ClearCacheResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ClearCacheRequest
extends RequestBase {
    @Nullable
    private final List<String> index;
    @Nullable
    private final List<ExpandWildcardOptions> expandWildcards;
    @Nullable
    private final Boolean allowNoIndices;
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Boolean pretty;
    @Nullable
    private final Boolean human;
    public static final Endpoint<ClearCacheRequest, ClearCacheResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ClearCacheRequest, ClearCacheResponse>(request -> "POST", request -> {
        boolean _index = true;
        boolean propsSet = false;
        if (request.index() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_searchable_snapshots");
            buf.append("/cache");
            buf.append("/clear");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/");
            SimpleEndpoint.pathEncode(request.index.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_searchable_snapshots");
            buf.append("/cache");
            buf.append("/clear");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.expandWildcards != null) {
            params.put("expand_wildcards", request.expandWildcards.stream().map(v -> v.toString()).collect(Collectors.joining(",")));
        }
        if (request.allowNoIndices != null) {
            params.put("allow_no_indices", String.valueOf(request.allowNoIndices));
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        if (request.pretty != null) {
            params.put("pretty", String.valueOf(request.pretty));
        }
        if (request.human != null) {
            params.put("human", String.valueOf(request.human));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, ClearCacheResponse._DESERIALIZER);

    public ClearCacheRequest(Builder builder) {
        this.index = ModelTypeHelper.unmodifiable(builder.index);
        this.expandWildcards = ModelTypeHelper.unmodifiable(builder.expandWildcards);
        this.allowNoIndices = builder.allowNoIndices;
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.pretty = builder.pretty;
        this.human = builder.human;
    }

    public ClearCacheRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> index() {
        return this.index;
    }

    @Nullable
    public List<ExpandWildcardOptions> expandWildcards() {
        return this.expandWildcards;
    }

    @Nullable
    public Boolean allowNoIndices() {
        return this.allowNoIndices;
    }

    @Nullable
    public Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public Boolean pretty() {
        return this.pretty;
    }

    @Nullable
    public Boolean human() {
        return this.human;
    }

    public static class Builder
    implements ObjectBuilder<ClearCacheRequest> {
        @Nullable
        private List<String> index;
        @Nullable
        private List<ExpandWildcardOptions> expandWildcards;
        @Nullable
        private Boolean allowNoIndices;
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Boolean pretty;
        @Nullable
        private Boolean human;

        public Builder index(@Nullable List<String> value) {
            this.index = value;
            return this;
        }

        public Builder index(String ... value) {
            this.index = Arrays.asList(value);
            return this;
        }

        public Builder addIndex(String value) {
            if (this.index == null) {
                this.index = new ArrayList<String>();
            }
            this.index.add(value);
            return this;
        }

        public Builder expandWildcards(@Nullable List<ExpandWildcardOptions> value) {
            this.expandWildcards = value;
            return this;
        }

        public Builder expandWildcards(ExpandWildcardOptions ... value) {
            this.expandWildcards = Arrays.asList(value);
            return this;
        }

        public Builder addExpandWildcards(ExpandWildcardOptions value) {
            if (this.expandWildcards == null) {
                this.expandWildcards = new ArrayList<ExpandWildcardOptions>();
            }
            this.expandWildcards.add(value);
            return this;
        }

        public Builder allowNoIndices(@Nullable Boolean value) {
            this.allowNoIndices = value;
            return this;
        }

        public Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public Builder pretty(@Nullable Boolean value) {
            this.pretty = value;
            return this;
        }

        public Builder human(@Nullable Boolean value) {
            this.human = value;
            return this;
        }

        @Override
        public ClearCacheRequest build() {
            return new ClearCacheRequest(this);
        }
    }
}

