/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.get_jobs;

import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class RollupJobStats
implements JsonpSerializable {
    private final long documentsProcessed;
    private final long indexFailures;
    private final long indexTimeInMs;
    private final long indexTotal;
    private final long pagesProcessed;
    private final long rollupsIndexed;
    private final long searchFailures;
    private final long searchTimeInMs;
    private final long searchTotal;
    private final long triggerCount;
    private final long processingTimeInMs;
    private final long processingTotal;
    public static final JsonpDeserializer<RollupJobStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RollupJobStats::setupRollupJobStatsDeserializer, Builder::build);

    public RollupJobStats(Builder builder) {
        this.documentsProcessed = Objects.requireNonNull(builder.documentsProcessed, "documents_processed");
        this.indexFailures = Objects.requireNonNull(builder.indexFailures, "index_failures");
        this.indexTimeInMs = Objects.requireNonNull(builder.indexTimeInMs, "index_time_in_ms");
        this.indexTotal = Objects.requireNonNull(builder.indexTotal, "index_total");
        this.pagesProcessed = Objects.requireNonNull(builder.pagesProcessed, "pages_processed");
        this.rollupsIndexed = Objects.requireNonNull(builder.rollupsIndexed, "rollups_indexed");
        this.searchFailures = Objects.requireNonNull(builder.searchFailures, "search_failures");
        this.searchTimeInMs = Objects.requireNonNull(builder.searchTimeInMs, "search_time_in_ms");
        this.searchTotal = Objects.requireNonNull(builder.searchTotal, "search_total");
        this.triggerCount = Objects.requireNonNull(builder.triggerCount, "trigger_count");
        this.processingTimeInMs = Objects.requireNonNull(builder.processingTimeInMs, "processing_time_in_ms");
        this.processingTotal = Objects.requireNonNull(builder.processingTotal, "processing_total");
    }

    public RollupJobStats(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public long documentsProcessed() {
        return this.documentsProcessed;
    }

    public long indexFailures() {
        return this.indexFailures;
    }

    public long indexTimeInMs() {
        return this.indexTimeInMs;
    }

    public long indexTotal() {
        return this.indexTotal;
    }

    public long pagesProcessed() {
        return this.pagesProcessed;
    }

    public long rollupsIndexed() {
        return this.rollupsIndexed;
    }

    public long searchFailures() {
        return this.searchFailures;
    }

    public long searchTimeInMs() {
        return this.searchTimeInMs;
    }

    public long searchTotal() {
        return this.searchTotal;
    }

    public long triggerCount() {
        return this.triggerCount;
    }

    public long processingTimeInMs() {
        return this.processingTimeInMs;
    }

    public long processingTotal() {
        return this.processingTotal;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("documents_processed");
        generator.write(this.documentsProcessed);
        generator.writeKey("index_failures");
        generator.write(this.indexFailures);
        generator.writeKey("index_time_in_ms");
        generator.write(this.indexTimeInMs);
        generator.writeKey("index_total");
        generator.write(this.indexTotal);
        generator.writeKey("pages_processed");
        generator.write(this.pagesProcessed);
        generator.writeKey("rollups_indexed");
        generator.write(this.rollupsIndexed);
        generator.writeKey("search_failures");
        generator.write(this.searchFailures);
        generator.writeKey("search_time_in_ms");
        generator.write(this.searchTimeInMs);
        generator.writeKey("search_total");
        generator.write(this.searchTotal);
        generator.writeKey("trigger_count");
        generator.write(this.triggerCount);
        generator.writeKey("processing_time_in_ms");
        generator.write(this.processingTimeInMs);
        generator.writeKey("processing_total");
        generator.write(this.processingTotal);
    }

    protected static void setupRollupJobStatsDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::documentsProcessed, JsonpDeserializer.longDeserializer(), "documents_processed", new String[0]);
        op.add(Builder::indexFailures, JsonpDeserializer.longDeserializer(), "index_failures", new String[0]);
        op.add(Builder::indexTimeInMs, JsonpDeserializer.longDeserializer(), "index_time_in_ms", new String[0]);
        op.add(Builder::indexTotal, JsonpDeserializer.longDeserializer(), "index_total", new String[0]);
        op.add(Builder::pagesProcessed, JsonpDeserializer.longDeserializer(), "pages_processed", new String[0]);
        op.add(Builder::rollupsIndexed, JsonpDeserializer.longDeserializer(), "rollups_indexed", new String[0]);
        op.add(Builder::searchFailures, JsonpDeserializer.longDeserializer(), "search_failures", new String[0]);
        op.add(Builder::searchTimeInMs, JsonpDeserializer.longDeserializer(), "search_time_in_ms", new String[0]);
        op.add(Builder::searchTotal, JsonpDeserializer.longDeserializer(), "search_total", new String[0]);
        op.add(Builder::triggerCount, JsonpDeserializer.longDeserializer(), "trigger_count", new String[0]);
        op.add(Builder::processingTimeInMs, JsonpDeserializer.longDeserializer(), "processing_time_in_ms", new String[0]);
        op.add(Builder::processingTotal, JsonpDeserializer.longDeserializer(), "processing_total", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<RollupJobStats> {
        private Long documentsProcessed;
        private Long indexFailures;
        private Long indexTimeInMs;
        private Long indexTotal;
        private Long pagesProcessed;
        private Long rollupsIndexed;
        private Long searchFailures;
        private Long searchTimeInMs;
        private Long searchTotal;
        private Long triggerCount;
        private Long processingTimeInMs;
        private Long processingTotal;

        public Builder documentsProcessed(long value) {
            this.documentsProcessed = value;
            return this;
        }

        public Builder indexFailures(long value) {
            this.indexFailures = value;
            return this;
        }

        public Builder indexTimeInMs(long value) {
            this.indexTimeInMs = value;
            return this;
        }

        public Builder indexTotal(long value) {
            this.indexTotal = value;
            return this;
        }

        public Builder pagesProcessed(long value) {
            this.pagesProcessed = value;
            return this;
        }

        public Builder rollupsIndexed(long value) {
            this.rollupsIndexed = value;
            return this;
        }

        public Builder searchFailures(long value) {
            this.searchFailures = value;
            return this;
        }

        public Builder searchTimeInMs(long value) {
            this.searchTimeInMs = value;
            return this;
        }

        public Builder searchTotal(long value) {
            this.searchTotal = value;
            return this;
        }

        public Builder triggerCount(long value) {
            this.triggerCount = value;
            return this;
        }

        public Builder processingTimeInMs(long value) {
            this.processingTimeInMs = value;
            return this;
        }

        public Builder processingTotal(long value) {
            this.processingTotal = value;
            return this;
        }

        @Override
        public RollupJobStats build() {
            return new RollupJobStats(this);
        }
    }
}

