/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.rollup.delete_job;

import co.elastic.clients.elasticsearch.rollup.delete_job.TaskFailureReason;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class TaskFailure
implements JsonpSerializable {
    private final String taskId;
    private final String nodeId;
    private final String status;
    private final TaskFailureReason reason;
    public static final JsonpDeserializer<TaskFailure> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TaskFailure::setupTaskFailureDeserializer, Builder::build);

    public TaskFailure(Builder builder) {
        this.taskId = Objects.requireNonNull(builder.taskId, "task_id");
        this.nodeId = Objects.requireNonNull(builder.nodeId, "node_id");
        this.status = Objects.requireNonNull(builder.status, "status");
        this.reason = Objects.requireNonNull(builder.reason, "reason");
    }

    public TaskFailure(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String taskId() {
        return this.taskId;
    }

    public String nodeId() {
        return this.nodeId;
    }

    public String status() {
        return this.status;
    }

    public TaskFailureReason reason() {
        return this.reason;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("task_id");
        generator.write(this.taskId);
        generator.writeKey("node_id");
        generator.write(this.nodeId);
        generator.writeKey("status");
        generator.write(this.status);
        generator.writeKey("reason");
        this.reason.serialize(generator, mapper);
    }

    protected static void setupTaskFailureDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::taskId, JsonpDeserializer.stringDeserializer(), "task_id", new String[0]);
        op.add(Builder::nodeId, JsonpDeserializer.stringDeserializer(), "node_id", new String[0]);
        op.add(Builder::status, JsonpDeserializer.stringDeserializer(), "status", new String[0]);
        op.add(Builder::reason, TaskFailureReason._DESERIALIZER, "reason", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<TaskFailure> {
        private String taskId;
        private String nodeId;
        private String status;
        private TaskFailureReason reason;

        public Builder taskId(String value) {
            this.taskId = value;
            return this;
        }

        public Builder nodeId(String value) {
            this.nodeId = value;
            return this;
        }

        public Builder status(String value) {
            this.status = value;
            return this;
        }

        public Builder reason(TaskFailureReason value) {
            this.reason = value;
            return this;
        }

        public Builder reason(Function<TaskFailureReason.Builder, ObjectBuilder<TaskFailureReason>> fn) {
            return this.reason(fn.apply(new TaskFailureReason.Builder()).build());
        }

        @Override
        public TaskFailure build() {
            return new TaskFailure(this);
        }
    }
}

