/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes.info;

import co.elastic.clients.elasticsearch._types.NodeRole;
import co.elastic.clients.elasticsearch._types.PluginStats;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoAggregation;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoHttp;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoIngest;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoNetwork;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoSettings;
import co.elastic.clients.elasticsearch.nodes.info.NodeInfoTransport;
import co.elastic.clients.elasticsearch.nodes.info.NodeJvmInfo;
import co.elastic.clients.elasticsearch.nodes.info.NodeOperatingSystemInfo;
import co.elastic.clients.elasticsearch.nodes.info.NodeProcessInfo;
import co.elastic.clients.elasticsearch.nodes.info.NodeThreadPoolInfo;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class NodeInfo
implements JsonpSerializable {
    private final Map<String, String> attributes;
    private final String buildFlavor;
    private final String buildHash;
    private final String buildType;
    private final String host;
    @Nullable
    private final NodeInfoHttp http;
    private final String ip;
    @Nullable
    private final NodeJvmInfo jvm;
    private final String name;
    @Nullable
    private final NodeInfoNetwork network;
    @Nullable
    private final NodeOperatingSystemInfo os;
    @Nullable
    private final List<PluginStats> plugins;
    @Nullable
    private final NodeProcessInfo process;
    private final List<NodeRole> roles;
    @Nullable
    private final NodeInfoSettings settings;
    @Nullable
    private final Map<String, NodeThreadPoolInfo> threadPool;
    @Nullable
    private final Long totalIndexingBuffer;
    @Nullable
    private final String totalIndexingBufferInBytes;
    @Nullable
    private final NodeInfoTransport transport;
    private final String transportAddress;
    private final String version;
    @Nullable
    private final List<PluginStats> modules;
    @Nullable
    private final NodeInfoIngest ingest;
    @Nullable
    private final Map<String, NodeInfoAggregation> aggregations;
    public static final JsonpDeserializer<NodeInfo> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, NodeInfo::setupNodeInfoDeserializer, Builder::build);

    public NodeInfo(Builder builder) {
        this.attributes = ModelTypeHelper.unmodifiableNonNull(builder.attributes, "attributes");
        this.buildFlavor = Objects.requireNonNull(builder.buildFlavor, "build_flavor");
        this.buildHash = Objects.requireNonNull(builder.buildHash, "build_hash");
        this.buildType = Objects.requireNonNull(builder.buildType, "build_type");
        this.host = Objects.requireNonNull(builder.host, "host");
        this.http = builder.http;
        this.ip = Objects.requireNonNull(builder.ip, "ip");
        this.jvm = builder.jvm;
        this.name = Objects.requireNonNull(builder.name, "name");
        this.network = builder.network;
        this.os = builder.os;
        this.plugins = ModelTypeHelper.unmodifiable(builder.plugins);
        this.process = builder.process;
        this.roles = ModelTypeHelper.unmodifiableNonNull(builder.roles, "roles");
        this.settings = builder.settings;
        this.threadPool = ModelTypeHelper.unmodifiable(builder.threadPool);
        this.totalIndexingBuffer = builder.totalIndexingBuffer;
        this.totalIndexingBufferInBytes = builder.totalIndexingBufferInBytes;
        this.transport = builder.transport;
        this.transportAddress = Objects.requireNonNull(builder.transportAddress, "transport_address");
        this.version = Objects.requireNonNull(builder.version, "version");
        this.modules = ModelTypeHelper.unmodifiable(builder.modules);
        this.ingest = builder.ingest;
        this.aggregations = ModelTypeHelper.unmodifiable(builder.aggregations);
    }

    public NodeInfo(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public String buildFlavor() {
        return this.buildFlavor;
    }

    public String buildHash() {
        return this.buildHash;
    }

    public String buildType() {
        return this.buildType;
    }

    public String host() {
        return this.host;
    }

    @Nullable
    public NodeInfoHttp http() {
        return this.http;
    }

    public String ip() {
        return this.ip;
    }

    @Nullable
    public NodeJvmInfo jvm() {
        return this.jvm;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public NodeInfoNetwork network() {
        return this.network;
    }

    @Nullable
    public NodeOperatingSystemInfo os() {
        return this.os;
    }

    @Nullable
    public List<PluginStats> plugins() {
        return this.plugins;
    }

    @Nullable
    public NodeProcessInfo process() {
        return this.process;
    }

    public List<NodeRole> roles() {
        return this.roles;
    }

    @Nullable
    public NodeInfoSettings settings() {
        return this.settings;
    }

    @Nullable
    public Map<String, NodeThreadPoolInfo> threadPool() {
        return this.threadPool;
    }

    @Nullable
    public Long totalIndexingBuffer() {
        return this.totalIndexingBuffer;
    }

    @Nullable
    public String totalIndexingBufferInBytes() {
        return this.totalIndexingBufferInBytes;
    }

    @Nullable
    public NodeInfoTransport transport() {
        return this.transport;
    }

    public String transportAddress() {
        return this.transportAddress;
    }

    public String version() {
        return this.version;
    }

    @Nullable
    public List<PluginStats> modules() {
        return this.modules;
    }

    @Nullable
    public NodeInfoIngest ingest() {
        return this.ingest;
    }

    @Nullable
    public Map<String, NodeInfoAggregation> aggregations() {
        return this.aggregations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("attributes");
        generator.writeStartObject();
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            generator.writeKey(entry.getKey());
            generator.write(entry.getValue());
        }
        generator.writeEnd();
        generator.writeKey("build_flavor");
        generator.write(this.buildFlavor);
        generator.writeKey("build_hash");
        generator.write(this.buildHash);
        generator.writeKey("build_type");
        generator.write(this.buildType);
        generator.writeKey("host");
        generator.write(this.host);
        if (this.http != null) {
            generator.writeKey("http");
            this.http.serialize(generator, mapper);
        }
        generator.writeKey("ip");
        generator.write(this.ip);
        if (this.jvm != null) {
            generator.writeKey("jvm");
            this.jvm.serialize(generator, mapper);
        }
        generator.writeKey("name");
        generator.write(this.name);
        if (this.network != null) {
            generator.writeKey("network");
            this.network.serialize(generator, mapper);
        }
        if (this.os != null) {
            generator.writeKey("os");
            this.os.serialize(generator, mapper);
        }
        if (this.plugins != null) {
            generator.writeKey("plugins");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.plugins) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.process != null) {
            generator.writeKey("process");
            this.process.serialize(generator, mapper);
        }
        generator.writeKey("roles");
        generator.writeStartArray();
        for (NodeRole nodeRole : this.roles) {
            nodeRole.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.settings != null) {
            generator.writeKey("settings");
            this.settings.serialize(generator, mapper);
        }
        if (this.threadPool != null) {
            generator.writeKey("thread_pool");
            generator.writeStartObject();
            for (Map.Entry entry : this.threadPool.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((NodeThreadPoolInfo)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalIndexingBuffer != null) {
            generator.writeKey("total_indexing_buffer");
            generator.write(this.totalIndexingBuffer.longValue());
        }
        if (this.totalIndexingBufferInBytes != null) {
            generator.writeKey("total_indexing_buffer_in_bytes");
            generator.write(this.totalIndexingBufferInBytes);
        }
        if (this.transport != null) {
            generator.writeKey("transport");
            this.transport.serialize(generator, mapper);
        }
        generator.writeKey("transport_address");
        generator.write(this.transportAddress);
        generator.writeKey("version");
        generator.write(this.version);
        if (this.modules != null) {
            generator.writeKey("modules");
            generator.writeStartArray();
            for (PluginStats pluginStats : this.modules) {
                pluginStats.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.ingest != null) {
            generator.writeKey("ingest");
            this.ingest.serialize(generator, mapper);
        }
        if (this.aggregations != null) {
            generator.writeKey("aggregations");
            generator.writeStartObject();
            for (Map.Entry entry : this.aggregations.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((NodeInfoAggregation)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupNodeInfoDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::attributes, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "attributes", new String[0]);
        op.add(Builder::buildFlavor, JsonpDeserializer.stringDeserializer(), "build_flavor", new String[0]);
        op.add(Builder::buildHash, JsonpDeserializer.stringDeserializer(), "build_hash", new String[0]);
        op.add(Builder::buildType, JsonpDeserializer.stringDeserializer(), "build_type", new String[0]);
        op.add(Builder::host, JsonpDeserializer.stringDeserializer(), "host", new String[0]);
        op.add(Builder::http, NodeInfoHttp._DESERIALIZER, "http", new String[0]);
        op.add(Builder::ip, JsonpDeserializer.stringDeserializer(), "ip", new String[0]);
        op.add(Builder::jvm, NodeJvmInfo._DESERIALIZER, "jvm", new String[0]);
        op.add(Builder::name, JsonpDeserializer.stringDeserializer(), "name", new String[0]);
        op.add(Builder::network, NodeInfoNetwork._DESERIALIZER, "network", new String[0]);
        op.add(Builder::os, NodeOperatingSystemInfo._DESERIALIZER, "os", new String[0]);
        op.add(Builder::plugins, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "plugins", new String[0]);
        op.add(Builder::process, NodeProcessInfo._DESERIALIZER, "process", new String[0]);
        op.add(Builder::roles, JsonpDeserializer.arrayDeserializer(NodeRole._DESERIALIZER), "roles", new String[0]);
        op.add(Builder::settings, NodeInfoSettings._DESERIALIZER, "settings", new String[0]);
        op.add(Builder::threadPool, JsonpDeserializer.stringMapDeserializer(NodeThreadPoolInfo._DESERIALIZER), "thread_pool", new String[0]);
        op.add(Builder::totalIndexingBuffer, JsonpDeserializer.longDeserializer(), "total_indexing_buffer", new String[0]);
        op.add(Builder::totalIndexingBufferInBytes, JsonpDeserializer.stringDeserializer(), "total_indexing_buffer_in_bytes", new String[0]);
        op.add(Builder::transport, NodeInfoTransport._DESERIALIZER, "transport", new String[0]);
        op.add(Builder::transportAddress, JsonpDeserializer.stringDeserializer(), "transport_address", new String[0]);
        op.add(Builder::version, JsonpDeserializer.stringDeserializer(), "version", new String[0]);
        op.add(Builder::modules, JsonpDeserializer.arrayDeserializer(PluginStats._DESERIALIZER), "modules", new String[0]);
        op.add(Builder::ingest, NodeInfoIngest._DESERIALIZER, "ingest", new String[0]);
        op.add(Builder::aggregations, JsonpDeserializer.stringMapDeserializer(NodeInfoAggregation._DESERIALIZER), "aggregations", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<NodeInfo> {
        private Map<String, String> attributes;
        private String buildFlavor;
        private String buildHash;
        private String buildType;
        private String host;
        @Nullable
        private NodeInfoHttp http;
        private String ip;
        @Nullable
        private NodeJvmInfo jvm;
        private String name;
        @Nullable
        private NodeInfoNetwork network;
        @Nullable
        private NodeOperatingSystemInfo os;
        @Nullable
        private List<PluginStats> plugins;
        @Nullable
        private NodeProcessInfo process;
        private List<NodeRole> roles;
        @Nullable
        private NodeInfoSettings settings;
        @Nullable
        private Map<String, NodeThreadPoolInfo> threadPool;
        @Nullable
        private Long totalIndexingBuffer;
        @Nullable
        private String totalIndexingBufferInBytes;
        @Nullable
        private NodeInfoTransport transport;
        private String transportAddress;
        private String version;
        @Nullable
        private List<PluginStats> modules;
        @Nullable
        private NodeInfoIngest ingest;
        @Nullable
        private Map<String, NodeInfoAggregation> aggregations;

        public Builder attributes(Map<String, String> value) {
            this.attributes = value;
            return this;
        }

        public Builder putAttributes(String key, String value) {
            if (this.attributes == null) {
                this.attributes = new HashMap<String, String>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Builder buildFlavor(String value) {
            this.buildFlavor = value;
            return this;
        }

        public Builder buildHash(String value) {
            this.buildHash = value;
            return this;
        }

        public Builder buildType(String value) {
            this.buildType = value;
            return this;
        }

        public Builder host(String value) {
            this.host = value;
            return this;
        }

        public Builder http(@Nullable NodeInfoHttp value) {
            this.http = value;
            return this;
        }

        public Builder http(Function<NodeInfoHttp.Builder, ObjectBuilder<NodeInfoHttp>> fn) {
            return this.http(fn.apply(new NodeInfoHttp.Builder()).build());
        }

        public Builder ip(String value) {
            this.ip = value;
            return this;
        }

        public Builder jvm(@Nullable NodeJvmInfo value) {
            this.jvm = value;
            return this;
        }

        public Builder jvm(Function<NodeJvmInfo.Builder, ObjectBuilder<NodeJvmInfo>> fn) {
            return this.jvm(fn.apply(new NodeJvmInfo.Builder()).build());
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder network(@Nullable NodeInfoNetwork value) {
            this.network = value;
            return this;
        }

        public Builder network(Function<NodeInfoNetwork.Builder, ObjectBuilder<NodeInfoNetwork>> fn) {
            return this.network(fn.apply(new NodeInfoNetwork.Builder()).build());
        }

        public Builder os(@Nullable NodeOperatingSystemInfo value) {
            this.os = value;
            return this;
        }

        public Builder os(Function<NodeOperatingSystemInfo.Builder, ObjectBuilder<NodeOperatingSystemInfo>> fn) {
            return this.os(fn.apply(new NodeOperatingSystemInfo.Builder()).build());
        }

        public Builder plugins(@Nullable List<PluginStats> value) {
            this.plugins = value;
            return this;
        }

        public Builder plugins(PluginStats ... value) {
            this.plugins = Arrays.asList(value);
            return this;
        }

        public Builder addPlugins(PluginStats value) {
            if (this.plugins == null) {
                this.plugins = new ArrayList<PluginStats>();
            }
            this.plugins.add(value);
            return this;
        }

        public Builder plugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.plugins(fn.apply(new PluginStats.Builder()).build());
        }

        public Builder addPlugins(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.addPlugins(fn.apply(new PluginStats.Builder()).build());
        }

        public Builder process(@Nullable NodeProcessInfo value) {
            this.process = value;
            return this;
        }

        public Builder process(Function<NodeProcessInfo.Builder, ObjectBuilder<NodeProcessInfo>> fn) {
            return this.process(fn.apply(new NodeProcessInfo.Builder()).build());
        }

        public Builder roles(List<NodeRole> value) {
            this.roles = value;
            return this;
        }

        public Builder roles(NodeRole ... value) {
            this.roles = Arrays.asList(value);
            return this;
        }

        public Builder addRoles(NodeRole value) {
            if (this.roles == null) {
                this.roles = new ArrayList<NodeRole>();
            }
            this.roles.add(value);
            return this;
        }

        public Builder settings(@Nullable NodeInfoSettings value) {
            this.settings = value;
            return this;
        }

        public Builder settings(Function<NodeInfoSettings.Builder, ObjectBuilder<NodeInfoSettings>> fn) {
            return this.settings(fn.apply(new NodeInfoSettings.Builder()).build());
        }

        public Builder threadPool(@Nullable Map<String, NodeThreadPoolInfo> value) {
            this.threadPool = value;
            return this;
        }

        public Builder putThreadPool(String key, NodeThreadPoolInfo value) {
            if (this.threadPool == null) {
                this.threadPool = new HashMap<String, NodeThreadPoolInfo>();
            }
            this.threadPool.put(key, value);
            return this;
        }

        public Builder threadPool(String key, Function<NodeThreadPoolInfo.Builder, ObjectBuilder<NodeThreadPoolInfo>> fn) {
            return this.threadPool(Collections.singletonMap(key, fn.apply(new NodeThreadPoolInfo.Builder()).build()));
        }

        public Builder putThreadPool(String key, Function<NodeThreadPoolInfo.Builder, ObjectBuilder<NodeThreadPoolInfo>> fn) {
            return this.putThreadPool(key, fn.apply(new NodeThreadPoolInfo.Builder()).build());
        }

        public Builder totalIndexingBuffer(@Nullable Long value) {
            this.totalIndexingBuffer = value;
            return this;
        }

        public Builder totalIndexingBufferInBytes(@Nullable String value) {
            this.totalIndexingBufferInBytes = value;
            return this;
        }

        public Builder transport(@Nullable NodeInfoTransport value) {
            this.transport = value;
            return this;
        }

        public Builder transport(Function<NodeInfoTransport.Builder, ObjectBuilder<NodeInfoTransport>> fn) {
            return this.transport(fn.apply(new NodeInfoTransport.Builder()).build());
        }

        public Builder transportAddress(String value) {
            this.transportAddress = value;
            return this;
        }

        public Builder version(String value) {
            this.version = value;
            return this;
        }

        public Builder modules(@Nullable List<PluginStats> value) {
            this.modules = value;
            return this;
        }

        public Builder modules(PluginStats ... value) {
            this.modules = Arrays.asList(value);
            return this;
        }

        public Builder addModules(PluginStats value) {
            if (this.modules == null) {
                this.modules = new ArrayList<PluginStats>();
            }
            this.modules.add(value);
            return this;
        }

        public Builder modules(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.modules(fn.apply(new PluginStats.Builder()).build());
        }

        public Builder addModules(Function<PluginStats.Builder, ObjectBuilder<PluginStats>> fn) {
            return this.addModules(fn.apply(new PluginStats.Builder()).build());
        }

        public Builder ingest(@Nullable NodeInfoIngest value) {
            this.ingest = value;
            return this;
        }

        public Builder ingest(Function<NodeInfoIngest.Builder, ObjectBuilder<NodeInfoIngest>> fn) {
            return this.ingest(fn.apply(new NodeInfoIngest.Builder()).build());
        }

        public Builder aggregations(@Nullable Map<String, NodeInfoAggregation> value) {
            this.aggregations = value;
            return this;
        }

        public Builder putAggregations(String key, NodeInfoAggregation value) {
            if (this.aggregations == null) {
                this.aggregations = new HashMap<String, NodeInfoAggregation>();
            }
            this.aggregations.put(key, value);
            return this;
        }

        public Builder aggregations(String key, Function<NodeInfoAggregation.Builder, ObjectBuilder<NodeInfoAggregation>> fn) {
            return this.aggregations(Collections.singletonMap(key, fn.apply(new NodeInfoAggregation.Builder()).build()));
        }

        public Builder putAggregations(String key, Function<NodeInfoAggregation.Builder, ObjectBuilder<NodeInfoAggregation>> fn) {
            return this.putAggregations(key, fn.apply(new NodeInfoAggregation.Builder()).build());
        }

        @Override
        public NodeInfo build() {
            return new NodeInfo(this);
        }
    }
}

