/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.Level;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.nodes.StatsResponse;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class StatsRequest
extends RequestBase {
    @Nullable
    private final List<String> nodeId;
    @Nullable
    private final List<String> metric;
    @Nullable
    private final List<String> indexMetric;
    @Nullable
    private final List<String> completionFields;
    @Nullable
    private final List<String> fielddataFields;
    @Nullable
    private final List<String> fields;
    @Nullable
    private final Boolean groups;
    @Nullable
    private final Boolean includeSegmentFileSizes;
    @Nullable
    private final Level level;
    @Nullable
    private final String masterTimeout;
    @Nullable
    private final String timeout;
    @Nullable
    private final List<String> types;
    @Nullable
    private final Boolean includeUnloadedSegments;
    public static final Endpoint<StatsRequest, StatsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<StatsRequest, StatsResponse>(request -> "GET", request -> {
        boolean _nodeId = true;
        int _metric = 2;
        int _indexMetric = 4;
        int propsSet = 0;
        if (request.nodeId() != null) {
            propsSet |= 1;
        }
        if (request.metric() != null) {
            propsSet |= 2;
        }
        if (request.indexMetric() != null) {
            propsSet |= 4;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            return buf.toString();
        }
        if (propsSet == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 6) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        if (propsSet == 7) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_nodes");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.nodeId.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/stats");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.metric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.indexMetric.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.completionFields != null) {
            params.put("completion_fields", request.completionFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.fielddataFields != null) {
            params.put("fielddata_fields", request.fielddataFields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.fields != null) {
            params.put("fields", request.fields.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.groups != null) {
            params.put("groups", String.valueOf(request.groups));
        }
        if (request.includeSegmentFileSizes != null) {
            params.put("include_segment_file_sizes", String.valueOf(request.includeSegmentFileSizes));
        }
        if (request.level != null) {
            params.put("level", request.level.toString());
        }
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout);
        }
        if (request.timeout != null) {
            params.put("timeout", request.timeout);
        }
        if (request.types != null) {
            params.put("types", request.types.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        if (request.includeUnloadedSegments != null) {
            params.put("include_unloaded_segments", String.valueOf(request.includeUnloadedSegments));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, StatsResponse._DESERIALIZER);

    public StatsRequest(Builder builder) {
        this.nodeId = ModelTypeHelper.unmodifiable(builder.nodeId);
        this.metric = ModelTypeHelper.unmodifiable(builder.metric);
        this.indexMetric = ModelTypeHelper.unmodifiable(builder.indexMetric);
        this.completionFields = ModelTypeHelper.unmodifiable(builder.completionFields);
        this.fielddataFields = ModelTypeHelper.unmodifiable(builder.fielddataFields);
        this.fields = ModelTypeHelper.unmodifiable(builder.fields);
        this.groups = builder.groups;
        this.includeSegmentFileSizes = builder.includeSegmentFileSizes;
        this.level = builder.level;
        this.masterTimeout = builder.masterTimeout;
        this.timeout = builder.timeout;
        this.types = ModelTypeHelper.unmodifiable(builder.types);
        this.includeUnloadedSegments = builder.includeUnloadedSegments;
    }

    public StatsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public List<String> nodeId() {
        return this.nodeId;
    }

    @Nullable
    public List<String> metric() {
        return this.metric;
    }

    @Nullable
    public List<String> indexMetric() {
        return this.indexMetric;
    }

    @Nullable
    public List<String> completionFields() {
        return this.completionFields;
    }

    @Nullable
    public List<String> fielddataFields() {
        return this.fielddataFields;
    }

    @Nullable
    public List<String> fields() {
        return this.fields;
    }

    @Nullable
    public Boolean groups() {
        return this.groups;
    }

    @Nullable
    public Boolean includeSegmentFileSizes() {
        return this.includeSegmentFileSizes;
    }

    @Nullable
    public Level level() {
        return this.level;
    }

    @Nullable
    public String masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public String timeout() {
        return this.timeout;
    }

    @Nullable
    public List<String> types() {
        return this.types;
    }

    @Nullable
    public Boolean includeUnloadedSegments() {
        return this.includeUnloadedSegments;
    }

    public static class Builder
    implements ObjectBuilder<StatsRequest> {
        @Nullable
        private List<String> nodeId;
        @Nullable
        private List<String> metric;
        @Nullable
        private List<String> indexMetric;
        @Nullable
        private List<String> completionFields;
        @Nullable
        private List<String> fielddataFields;
        @Nullable
        private List<String> fields;
        @Nullable
        private Boolean groups;
        @Nullable
        private Boolean includeSegmentFileSizes;
        @Nullable
        private Level level;
        @Nullable
        private String masterTimeout;
        @Nullable
        private String timeout;
        @Nullable
        private List<String> types;
        @Nullable
        private Boolean includeUnloadedSegments;

        public Builder nodeId(@Nullable List<String> value) {
            this.nodeId = value;
            return this;
        }

        public Builder nodeId(String ... value) {
            this.nodeId = Arrays.asList(value);
            return this;
        }

        public Builder addNodeId(String value) {
            if (this.nodeId == null) {
                this.nodeId = new ArrayList<String>();
            }
            this.nodeId.add(value);
            return this;
        }

        public Builder metric(@Nullable List<String> value) {
            this.metric = value;
            return this;
        }

        public Builder metric(String ... value) {
            this.metric = Arrays.asList(value);
            return this;
        }

        public Builder addMetric(String value) {
            if (this.metric == null) {
                this.metric = new ArrayList<String>();
            }
            this.metric.add(value);
            return this;
        }

        public Builder indexMetric(@Nullable List<String> value) {
            this.indexMetric = value;
            return this;
        }

        public Builder indexMetric(String ... value) {
            this.indexMetric = Arrays.asList(value);
            return this;
        }

        public Builder addIndexMetric(String value) {
            if (this.indexMetric == null) {
                this.indexMetric = new ArrayList<String>();
            }
            this.indexMetric.add(value);
            return this;
        }

        public Builder completionFields(@Nullable List<String> value) {
            this.completionFields = value;
            return this;
        }

        public Builder completionFields(String ... value) {
            this.completionFields = Arrays.asList(value);
            return this;
        }

        public Builder addCompletionFields(String value) {
            if (this.completionFields == null) {
                this.completionFields = new ArrayList<String>();
            }
            this.completionFields.add(value);
            return this;
        }

        public Builder fielddataFields(@Nullable List<String> value) {
            this.fielddataFields = value;
            return this;
        }

        public Builder fielddataFields(String ... value) {
            this.fielddataFields = Arrays.asList(value);
            return this;
        }

        public Builder addFielddataFields(String value) {
            if (this.fielddataFields == null) {
                this.fielddataFields = new ArrayList<String>();
            }
            this.fielddataFields.add(value);
            return this;
        }

        public Builder fields(@Nullable List<String> value) {
            this.fields = value;
            return this;
        }

        public Builder fields(String ... value) {
            this.fields = Arrays.asList(value);
            return this;
        }

        public Builder addFields(String value) {
            if (this.fields == null) {
                this.fields = new ArrayList<String>();
            }
            this.fields.add(value);
            return this;
        }

        public Builder groups(@Nullable Boolean value) {
            this.groups = value;
            return this;
        }

        public Builder includeSegmentFileSizes(@Nullable Boolean value) {
            this.includeSegmentFileSizes = value;
            return this;
        }

        public Builder level(@Nullable Level value) {
            this.level = value;
            return this;
        }

        public Builder masterTimeout(@Nullable String value) {
            this.masterTimeout = value;
            return this;
        }

        public Builder timeout(@Nullable String value) {
            this.timeout = value;
            return this;
        }

        public Builder types(@Nullable List<String> value) {
            this.types = value;
            return this;
        }

        public Builder types(String ... value) {
            this.types = Arrays.asList(value);
            return this;
        }

        public Builder addTypes(String value) {
            if (this.types == null) {
                this.types = new ArrayList<String>();
            }
            this.types.add(value);
            return this;
        }

        public Builder includeUnloadedSegments(@Nullable Boolean value) {
            this.includeUnloadedSegments = value;
            return this;
        }

        @Override
        public StatsRequest build() {
            return new StatsRequest(this);
        }
    }
}

