/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.nodes;

import co.elastic.clients.elasticsearch.nodes.Cpu;
import co.elastic.clients.elasticsearch.nodes.ExtendedMemoryStats;
import co.elastic.clients.elasticsearch.nodes.MemoryStats;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class OperatingSystem
implements JsonpSerializable {
    private final Cpu cpu;
    private final ExtendedMemoryStats mem;
    private final MemoryStats swap;
    private final long timestamp;
    public static final JsonpDeserializer<OperatingSystem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, OperatingSystem::setupOperatingSystemDeserializer, Builder::build);

    public OperatingSystem(Builder builder) {
        this.cpu = Objects.requireNonNull(builder.cpu, "cpu");
        this.mem = Objects.requireNonNull(builder.mem, "mem");
        this.swap = Objects.requireNonNull(builder.swap, "swap");
        this.timestamp = Objects.requireNonNull(builder.timestamp, "timestamp");
    }

    public OperatingSystem(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Cpu cpu() {
        return this.cpu;
    }

    public ExtendedMemoryStats mem() {
        return this.mem;
    }

    public MemoryStats swap() {
        return this.swap;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("cpu");
        this.cpu.serialize(generator, mapper);
        generator.writeKey("mem");
        this.mem.serialize(generator, mapper);
        generator.writeKey("swap");
        this.swap.serialize(generator, mapper);
        generator.writeKey("timestamp");
        generator.write(this.timestamp);
    }

    protected static void setupOperatingSystemDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::cpu, Cpu._DESERIALIZER, "cpu", new String[0]);
        op.add(Builder::mem, ExtendedMemoryStats._DESERIALIZER, "mem", new String[0]);
        op.add(Builder::swap, MemoryStats._DESERIALIZER, "swap", new String[0]);
        op.add(Builder::timestamp, JsonpDeserializer.longDeserializer(), "timestamp", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<OperatingSystem> {
        private Cpu cpu;
        private ExtendedMemoryStats mem;
        private MemoryStats swap;
        private Long timestamp;

        public Builder cpu(Cpu value) {
            this.cpu = value;
            return this;
        }

        public Builder cpu(Function<Cpu.Builder, ObjectBuilder<Cpu>> fn) {
            return this.cpu(fn.apply(new Cpu.Builder()).build());
        }

        public Builder mem(ExtendedMemoryStats value) {
            this.mem = value;
            return this;
        }

        public Builder mem(Function<ExtendedMemoryStats.Builder, ObjectBuilder<ExtendedMemoryStats>> fn) {
            return this.mem(fn.apply(new ExtendedMemoryStats.Builder()).build());
        }

        public Builder swap(MemoryStats value) {
            this.swap = value;
            return this;
        }

        public Builder swap(Function<MemoryStats.Builder, ObjectBuilder<MemoryStats>> fn) {
            return this.swap(fn.apply(new MemoryStats.Builder()).build());
        }

        public Builder timestamp(long value) {
            this.timestamp = value;
            return this;
        }

        @Override
        public OperatingSystem build() {
            return new OperatingSystem(this);
        }
    }
}

