/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.Detector;
import co.elastic.clients.elasticsearch.ml.ValidateDetectorResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;

@JsonpDeserializable
public final class ValidateDetectorRequest
extends RequestBase
implements JsonpSerializable {
    private final Detector detector;
    public static final JsonpDeserializer<ValidateDetectorRequest> _DESERIALIZER = ValidateDetectorRequest.createValidateDetectorRequestDeserializer();
    public static final Endpoint<ValidateDetectorRequest, ValidateDetectorResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<ValidateDetectorRequest, ValidateDetectorResponse>(request -> "POST", request -> "/_ml/anomaly_detectors/_validate/detector", request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, ValidateDetectorResponse._DESERIALIZER);

    public ValidateDetectorRequest(Builder builder) {
        this.detector = Objects.requireNonNull(builder.detector, "_value_body");
    }

    public ValidateDetectorRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public Detector detector() {
        return this.detector;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        this.detector.serialize(generator, mapper);
    }

    protected static JsonpDeserializer<ValidateDetectorRequest> createValidateDetectorRequestDeserializer() {
        JsonpDeserializer<Detector> valueDeserializer = Detector._DESERIALIZER;
        return JsonpDeserializer.of(valueDeserializer.acceptedEvents(), (parser, mapper, event) -> new Builder().detector((Detector)valueDeserializer.deserialize((JsonParser)parser, (JsonpMapper)mapper, (JsonParser.Event)event)).build());
    }

    public static class Builder
    implements ObjectBuilder<ValidateDetectorRequest> {
        private Detector detector;

        public Builder detector(Detector value) {
            this.detector = value;
            return this;
        }

        public Builder detector(Function<Detector.Builder, ObjectBuilder<Detector>> fn) {
            return this.detector(fn.apply(new Detector.Builder()).build());
        }

        @Override
        public ValidateDetectorRequest build() {
            return new ValidateDetectorRequest(this);
        }
    }
}

