/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.UpdateFilterResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class UpdateFilterRequest
extends RequestBase
implements JsonpSerializable {
    private final String filterId;
    @Nullable
    private final List<String> addItems;
    @Nullable
    private final String description;
    @Nullable
    private final List<String> removeItems;
    public static final JsonpDeserializer<UpdateFilterRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, UpdateFilterRequest::setupUpdateFilterRequestDeserializer, Builder::build);
    public static final Endpoint<UpdateFilterRequest, UpdateFilterResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<UpdateFilterRequest, UpdateFilterResponse>(request -> "POST", request -> {
        boolean _filterId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.filterId, buf);
            buf.append("/_update");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, UpdateFilterResponse._DESERIALIZER);

    public UpdateFilterRequest(Builder builder) {
        this.filterId = Objects.requireNonNull(builder.filterId, "filter_id");
        this.addItems = ModelTypeHelper.unmodifiable(builder.addItems);
        this.description = builder.description;
        this.removeItems = ModelTypeHelper.unmodifiable(builder.removeItems);
    }

    public UpdateFilterRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String filterId() {
        return this.filterId;
    }

    @Nullable
    public List<String> addItems() {
        return this.addItems;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public List<String> removeItems() {
        return this.removeItems;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.addItems != null) {
            generator.writeKey("add_items");
            generator.writeStartArray();
            for (String item0 : this.addItems) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.removeItems != null) {
            generator.writeKey("remove_items");
            generator.writeStartArray();
            for (String item0 : this.removeItems) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupUpdateFilterRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::addItems, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "add_items", new String[0]);
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::removeItems, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "remove_items", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<UpdateFilterRequest> {
        private String filterId;
        @Nullable
        private List<String> addItems;
        @Nullable
        private String description;
        @Nullable
        private List<String> removeItems;

        public Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public Builder addItems(@Nullable List<String> value) {
            this.addItems = value;
            return this;
        }

        public Builder addItems(String ... value) {
            this.addItems = Arrays.asList(value);
            return this;
        }

        public Builder addAddItems(String value) {
            if (this.addItems == null) {
                this.addItems = new ArrayList<String>();
            }
            this.addItems.add(value);
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder removeItems(@Nullable List<String> value) {
            this.removeItems = value;
            return this;
        }

        public Builder removeItems(String ... value) {
            this.removeItems = Arrays.asList(value);
            return this;
        }

        public Builder addRemoveItems(String value) {
            if (this.removeItems == null) {
                this.removeItems = new ArrayList<String>();
            }
            this.removeItems.add(value);
            return this;
        }

        @Override
        public UpdateFilterRequest build() {
            return new UpdateFilterRequest(this);
        }
    }
}

