/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutTrainedModelAliasResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class PutTrainedModelAliasRequest
extends RequestBase {
    private final String modelAlias;
    private final String modelId;
    @Nullable
    private final Boolean reassign;
    public static final Endpoint<PutTrainedModelAliasRequest, PutTrainedModelAliasResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutTrainedModelAliasRequest, PutTrainedModelAliasResponse>(request -> "PUT", request -> {
        boolean _modelAlias = true;
        int _modelId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            buf.append("/model_aliases");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelAlias, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.reassign != null) {
            params.put("reassign", String.valueOf(request.reassign));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, PutTrainedModelAliasResponse._DESERIALIZER);

    public PutTrainedModelAliasRequest(Builder builder) {
        this.modelAlias = Objects.requireNonNull(builder.modelAlias, "model_alias");
        this.modelId = Objects.requireNonNull(builder.modelId, "model_id");
        this.reassign = builder.reassign;
    }

    public PutTrainedModelAliasRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String modelAlias() {
        return this.modelAlias;
    }

    public String modelId() {
        return this.modelId;
    }

    @Nullable
    public Boolean reassign() {
        return this.reassign;
    }

    public static class Builder
    implements ObjectBuilder<PutTrainedModelAliasRequest> {
        private String modelAlias;
        private String modelId;
        @Nullable
        private Boolean reassign;

        public Builder modelAlias(String value) {
            this.modelAlias = value;
            return this;
        }

        public Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public Builder reassign(@Nullable Boolean value) {
            this.reassign = value;
            return this;
        }

        @Override
        public PutTrainedModelAliasRequest build() {
            return new PutTrainedModelAliasRequest(this);
        }
    }
}

