/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.PutFilterResponse;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ModelTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class PutFilterRequest
extends RequestBase
implements JsonpSerializable {
    private final String filterId;
    @Nullable
    private final String description;
    @Nullable
    private final List<String> items;
    public static final JsonpDeserializer<PutFilterRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, PutFilterRequest::setupPutFilterRequestDeserializer, Builder::build);
    public static final Endpoint<PutFilterRequest, PutFilterResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<PutFilterRequest, PutFilterResponse>(request -> "PUT", request -> {
        boolean _filterId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/filters");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.filterId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, PutFilterResponse._DESERIALIZER);

    public PutFilterRequest(Builder builder) {
        this.filterId = Objects.requireNonNull(builder.filterId, "filter_id");
        this.description = builder.description;
        this.items = ModelTypeHelper.unmodifiable(builder.items);
    }

    public PutFilterRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String filterId() {
        return this.filterId;
    }

    @Nullable
    public String description() {
        return this.description;
    }

    @Nullable
    public List<String> items() {
        return this.items;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.description != null) {
            generator.writeKey("description");
            generator.write(this.description);
        }
        if (this.items != null) {
            generator.writeKey("items");
            generator.writeStartArray();
            for (String item0 : this.items) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
    }

    protected static void setupPutFilterRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::description, JsonpDeserializer.stringDeserializer(), "description", new String[0]);
        op.add(Builder::items, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "items", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<PutFilterRequest> {
        private String filterId;
        @Nullable
        private String description;
        @Nullable
        private List<String> items;

        public Builder filterId(String value) {
            this.filterId = value;
            return this;
        }

        public Builder description(@Nullable String value) {
            this.description = value;
            return this;
        }

        public Builder items(@Nullable List<String> value) {
            this.items = value;
            return this;
        }

        public Builder items(String ... value) {
            this.items = Arrays.asList(value);
            return this;
        }

        public Builder addItems(String value) {
            if (this.items == null) {
                this.items = new ArrayList<String>();
            }
            this.items.add(value);
            return this;
        }

        @Override
        public PutFilterRequest build() {
            return new PutFilterRequest(this);
        }
    }
}

