/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetTrainedModelsResponse;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class GetTrainedModelsRequest
extends RequestBase {
    @Nullable
    private final String modelId;
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final Boolean decompressDefinition;
    @Nullable
    private final Boolean excludeGenerated;
    @Nullable
    private final Integer from;
    @Nullable
    private final String include;
    @Nullable
    private final Integer size;
    @Nullable
    private final String tags;
    public static final Endpoint<GetTrainedModelsRequest, GetTrainedModelsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetTrainedModelsRequest, GetTrainedModelsResponse>(request -> "GET", request -> {
        boolean _modelId = true;
        boolean propsSet = false;
        if (request.modelId() != null) {
            propsSet |= true;
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/trained_models");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        if (request.decompressDefinition != null) {
            params.put("decompress_definition", String.valueOf(request.decompressDefinition));
        }
        if (request.excludeGenerated != null) {
            params.put("exclude_generated", String.valueOf(request.excludeGenerated));
        }
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.include != null) {
            params.put("include", request.include);
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        if (request.tags != null) {
            params.put("tags", request.tags);
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetTrainedModelsResponse._DESERIALIZER);

    public GetTrainedModelsRequest(Builder builder) {
        this.modelId = builder.modelId;
        this.allowNoMatch = builder.allowNoMatch;
        this.decompressDefinition = builder.decompressDefinition;
        this.excludeGenerated = builder.excludeGenerated;
        this.from = builder.from;
        this.include = builder.include;
        this.size = builder.size;
        this.tags = builder.tags;
    }

    public GetTrainedModelsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    @Nullable
    public String modelId() {
        return this.modelId;
    }

    @Nullable
    public Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public Boolean decompressDefinition() {
        return this.decompressDefinition;
    }

    @Nullable
    public Boolean excludeGenerated() {
        return this.excludeGenerated;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public String include() {
        return this.include;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public String tags() {
        return this.tags;
    }

    public static class Builder
    implements ObjectBuilder<GetTrainedModelsRequest> {
        @Nullable
        private String modelId;
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private Boolean decompressDefinition;
        @Nullable
        private Boolean excludeGenerated;
        @Nullable
        private Integer from;
        @Nullable
        private String include;
        @Nullable
        private Integer size;
        @Nullable
        private String tags;

        public Builder modelId(@Nullable String value) {
            this.modelId = value;
            return this;
        }

        public Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public Builder decompressDefinition(@Nullable Boolean value) {
            this.decompressDefinition = value;
            return this;
        }

        public Builder excludeGenerated(@Nullable Boolean value) {
            this.excludeGenerated = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder include(@Nullable String value) {
            this.include = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder tags(@Nullable String value) {
            this.tags = value;
            return this;
        }

        @Override
        public GetTrainedModelsRequest build() {
            return new GetTrainedModelsRequest(this);
        }
    }
}

