/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.base.ElasticsearchError;
import co.elastic.clients.base.Endpoint;
import co.elastic.clients.base.SimpleEndpoint;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetBucketsResponse;
import co.elastic.clients.elasticsearch.ml.Page;
import co.elastic.clients.json.DelegatingDeserializer;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public final class GetBucketsRequest
extends RequestBase
implements JsonpSerializable {
    private final String jobId;
    @Nullable
    private final String timestamp;
    @Nullable
    private final Integer from;
    @Nullable
    private final Integer size;
    @Nullable
    private final Double anomalyScore;
    @Nullable
    private final Boolean desc;
    @Nullable
    private final Boolean excludeInterim;
    @Nullable
    private final Boolean expand;
    @Nullable
    private final Page page;
    @Nullable
    private final String sort;
    @Nullable
    private final String start;
    @Nullable
    private final String end;
    public static final JsonpDeserializer<GetBucketsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GetBucketsRequest::setupGetBucketsRequestDeserializer, Builder::build);
    public static final Endpoint<GetBucketsRequest, GetBucketsResponse, ElasticsearchError> ENDPOINT = new SimpleEndpoint<GetBucketsRequest, GetBucketsResponse>(request -> "POST", request -> {
        boolean _jobId = true;
        int _timestamp = 2;
        int propsSet = 0;
        propsSet |= 1;
        if (request.timestamp() != null) {
            propsSet |= 2;
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/buckets");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.timestamp, buf);
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/results");
            buf.append("/buckets");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.from != null) {
            params.put("from", String.valueOf(request.from));
        }
        if (request.size != null) {
            params.put("size", String.valueOf(request.size));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), true, GetBucketsResponse._DESERIALIZER);

    public GetBucketsRequest(Builder builder) {
        this.jobId = Objects.requireNonNull(builder.jobId, "job_id");
        this.timestamp = builder.timestamp;
        this.from = builder.from;
        this.size = builder.size;
        this.anomalyScore = builder.anomalyScore;
        this.desc = builder.desc;
        this.excludeInterim = builder.excludeInterim;
        this.expand = builder.expand;
        this.page = builder.page;
        this.sort = builder.sort;
        this.start = builder.start;
        this.end = builder.end;
    }

    public GetBucketsRequest(Function<Builder, Builder> fn) {
        this(fn.apply(new Builder()));
    }

    public String jobId() {
        return this.jobId;
    }

    @Nullable
    public String timestamp() {
        return this.timestamp;
    }

    @Nullable
    public Integer from() {
        return this.from;
    }

    @Nullable
    public Integer size() {
        return this.size;
    }

    @Nullable
    public Double anomalyScore() {
        return this.anomalyScore;
    }

    @Nullable
    public Boolean desc() {
        return this.desc;
    }

    @Nullable
    public Boolean excludeInterim() {
        return this.excludeInterim;
    }

    @Nullable
    public Boolean expand() {
        return this.expand;
    }

    @Nullable
    public Page page() {
        return this.page;
    }

    @Nullable
    public String sort() {
        return this.sort;
    }

    @Nullable
    public String start() {
        return this.start;
    }

    @Nullable
    public String end() {
        return this.end;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.anomalyScore != null) {
            generator.writeKey("anomaly_score");
            generator.write(this.anomalyScore.doubleValue());
        }
        if (this.desc != null) {
            generator.writeKey("desc");
            generator.write(this.desc.booleanValue());
        }
        if (this.excludeInterim != null) {
            generator.writeKey("exclude_interim");
            generator.write(this.excludeInterim.booleanValue());
        }
        if (this.expand != null) {
            generator.writeKey("expand");
            generator.write(this.expand.booleanValue());
        }
        if (this.page != null) {
            generator.writeKey("page");
            this.page.serialize(generator, mapper);
        }
        if (this.sort != null) {
            generator.writeKey("sort");
            generator.write(this.sort);
        }
        if (this.start != null) {
            generator.writeKey("start");
            generator.write(this.start);
        }
        if (this.end != null) {
            generator.writeKey("end");
            generator.write(this.end);
        }
    }

    protected static void setupGetBucketsRequestDeserializer(DelegatingDeserializer<Builder> op) {
        op.add(Builder::anomalyScore, JsonpDeserializer.doubleDeserializer(), "anomaly_score", new String[0]);
        op.add(Builder::desc, JsonpDeserializer.booleanDeserializer(), "desc", new String[0]);
        op.add(Builder::excludeInterim, JsonpDeserializer.booleanDeserializer(), "exclude_interim", new String[0]);
        op.add(Builder::expand, JsonpDeserializer.booleanDeserializer(), "expand", new String[0]);
        op.add(Builder::page, Page._DESERIALIZER, "page", new String[0]);
        op.add(Builder::sort, JsonpDeserializer.stringDeserializer(), "sort", new String[0]);
        op.add(Builder::start, JsonpDeserializer.stringDeserializer(), "start", new String[0]);
        op.add(Builder::end, JsonpDeserializer.stringDeserializer(), "end", new String[0]);
    }

    public static class Builder
    implements ObjectBuilder<GetBucketsRequest> {
        private String jobId;
        @Nullable
        private String timestamp;
        @Nullable
        private Integer from;
        @Nullable
        private Integer size;
        @Nullable
        private Double anomalyScore;
        @Nullable
        private Boolean desc;
        @Nullable
        private Boolean excludeInterim;
        @Nullable
        private Boolean expand;
        @Nullable
        private Page page;
        @Nullable
        private String sort;
        @Nullable
        private String start;
        @Nullable
        private String end;

        public Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public Builder timestamp(@Nullable String value) {
            this.timestamp = value;
            return this;
        }

        public Builder from(@Nullable Integer value) {
            this.from = value;
            return this;
        }

        public Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public Builder anomalyScore(@Nullable Double value) {
            this.anomalyScore = value;
            return this;
        }

        public Builder desc(@Nullable Boolean value) {
            this.desc = value;
            return this;
        }

        public Builder excludeInterim(@Nullable Boolean value) {
            this.excludeInterim = value;
            return this;
        }

        public Builder expand(@Nullable Boolean value) {
            this.expand = value;
            return this;
        }

        public Builder page(@Nullable Page value) {
            this.page = value;
            return this;
        }

        public Builder page(Function<Page.Builder, ObjectBuilder<Page>> fn) {
            return this.page(fn.apply(new Page.Builder()).build());
        }

        public Builder sort(@Nullable String value) {
            this.sort = value;
            return this;
        }

        public Builder start(@Nullable String value) {
            this.start = value;
            return this;
        }

        public Builder end(@Nullable String value) {
            this.end = value;
            return this;
        }

        @Override
        public GetBucketsRequest build() {
            return new GetBucketsRequest(this);
        }
    }
}

